package bookExamples.ch18Swing;

/*
 * TableDemo.java is a 1.4 application that requires no other files.
 */

import javax.swing.*;
import java.awt.*;

/**
 * JTableExample uses a custom TableModel.
 */
public class JTableExample {
    private final JPanel jp = new JPanel(new GridLayout(1, 0));
    private static final int VALUE = 20;
    private static final int WIDTH = 500;
    private static final int HEIGHT = 70;

    /**
    * A program to illustrate the use of the JTable
    */
    public JTableExample() {
         String[] columnNames = {"First Name",
                                        "Last Name",
                                        "Sport",
                                        "# of Years",
                                        "Vegetarian"};
         Object[][] data = {
            {"Mary", "Campione",
             "Snowboarding", new Integer(5), new Boolean(false)},
            {"Alison", "Huml",
             "Rowing", new Integer(3), new Boolean(true)},
            {"Kathy", "Walrath",
             "Knitting", new Integer(2), new Boolean(false)},
            {"Sharon", "Zakhour",
             "Speed reading", new Integer(VALUE), new Boolean(true)},
            {"Philip", "Milne",
             "Pool", new Integer(10), new Boolean(false)}
        };
        final TableData dm = new TableData(columnNames,data);
        JTable table = new JTable(dm.getTableModel());
        table.setPreferredScrollableViewportSize(new Dimension(WIDTH, HEIGHT));
        jp.add(new JScrollPane(table));
    }



    private static void initGui() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = initWindow();
        initContentPane(frame);
        frame.pack();
        frame.setVisible(true);
    }

    private static void initContentPane(JFrame frame) {
        JTableExample newContentPane = new JTableExample();
        //must paint every pixel in component bounds:
        newContentPane.jp.setOpaque(true);
        frame.setContentPane(newContentPane.jp);
    }

    private static JFrame initWindow() {
        JFrame frame = new JFrame("JTableExample");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        return frame;
    }
    /**
     * Args are unused...just start and display the
     * program.
     * @param args
     */
    public static void main(String[] args) {
        initGui();
    }
}
