/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Nov 6, 2003
 * Time: 7:31:53 PM
 * To change this template use Options | File Templates.
 */
package bookExamples.ch05ControlStructs;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.PrintWriter;
import java.io.IOException;

// examples.stringswitch.DispatchProcessor.doLogin

public class AddressDispatchProcessor {
    private final static ServletDispatcher sd = initServletDispatcher();

    public static void doLogin(HttpServletRequest request,
                               HttpServletResponse response)
            throws IOException {
        PrintWriter out = response.getWriter();
        HttpSession hs = request.getSession();
        hs.putValue("loggedIn", "false");
        out.println("<h1>here is the login page</h1>");
    }

    public static void doLogout(HttpServletRequest request,
                                HttpServletResponse response) {
        try {
            PrintWriter out = response.getWriter();
            HttpSession hs = request.getSession();
            hs.putValue("loggedIn", "false");
            out.println("<h1>here is the logout page</h1>");
            out.println("<h1>goodbye world</h1>");
        } catch (IOException e) {
            e.printStackTrace();  //To change body of catch statement use Options | File Templates.
        }
    }

    // examples.stringswitch.ServletDispatcherTest.getServletDispatcher();
    public static ServletDispatcher initServletDispatcher() {
        ServletDispatcher sd = new ServletDispatcher();
        sd.add(new DoLoginDispatchCommand());
        sd.add(new DispatchCommand("doLogout") {
            public void run(HttpServletRequest request, HttpServletResponse response) {
                doLogout(request, response);
            }
        });
        return sd;
    }

    public static ServletDispatcher getServletDispatcher() {
        return sd;
    }

    private static class DoLoginDispatchCommand extends DispatchCommand {
        public DoLoginDispatchCommand() {
            super("doLogin");
        }

        public void run(HttpServletRequest request, HttpServletResponse response) {
            try {

                doLogin(request, response);
            } catch (IOException e) {
                e.printStackTrace();  //To change body of catch statement use Options | File Templates.
            }
        }
    }
}
