package addBk.print.labels;


import javax.print.PrintService;
import java.awt.*;
import java.awt.geom.Rectangle2D;
import java.awt.print.*;

public class DymoPrinter implements Printable {

    public static void main(String[] args) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrintService[] printService = PrinterJob.lookupPrintServices();
        for (int i = 0; i < printService.length; i++) {
            System.out.println(printService[i].getName());
        }
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = new Paper();
        // this is in picas
        final double width = 3.5 * 72;
        final double height = 1.25 * 72;
        paper.setSize(width, height);
        // this is in pixels!
        paper.setImageableArea(0, 0, 1, 1);
        pageFormat.setOrientation(PageFormat.PORTRAIT);
        pageFormat.setPaper(paper);

        final PageFormat format = printerJob.pageDialog(pageFormat);
        System.out.println(
                "format=" + format.getWidth() + 'x' + format.getHeight());
        System.out.println(
                "pageFormat=" +
                pageFormat.getWidth() +
                'x' +
                pageFormat.getHeight());
        System.out.println("paper=" +
                paper.getWidth() +
                'x' +
                paper.getHeight());



        print(printerJob);

        System.exit(0);
    }

    private static void print(PrinterJob printerJob) {
        printerJob.setPrintable(new DymoPrinter());
        try {
            printerJob.print();
        } catch (PrinterException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public int print(Graphics graphics,
                     PageFormat pageFormat,
                     int pageIndex) throws PrinterException {
        Graphics2D g = (Graphics2D) graphics;
        // make (0,0) origin of printable area.
        final double x = pageFormat.getImageableX();
        final double y = pageFormat.getImageableY();
        g.translate(x, y);
        Rectangle2D.Double rectangle = new Rectangle2D.Double();


        final double w = pageFormat.getImageableWidth();
        final double h = pageFormat.getImageableHeight()-10;
        rectangle.setRect(x,y,w,h);

        g.draw(rectangle);
        g.drawString(x+","+y,(float)x,(float)y);
        g.drawString(w + ","+h, (float) w, (float) h);
        g.drawString("0,"+h, (float) 0, (float) h);
        g.drawString(w+",0", (float) w, (float) 0);

        if (pageIndex == 0) {
            System.out.println("pageFormat imageable X      = " +
                    x);
            System.out.println("imageable Y      = " +
                    y);
            System.out.println("pageFormat imageable Width  = " +
                    w);
            System.out.println("pageFormat imageable Height = " +
                    h);

            g.drawString("Creo Proofer Label", 20.0f, 20.0f);
            return PAGE_EXISTS;
        } else
            return NO_SUCH_PAGE;
    }
}

