/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 2, 2003
 * Time: 12:30:51 PM
 */
package addBk.print;

import javax.swing.*;
import java.awt.*;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.RandomAccessFile;

public class PrintUtils implements Printable {
    private RandomAccessFile raf;
    private String fileName;
    private Font fnt = new Font("Helvetica", Font.PLAIN, 10);
    private int rememberedPageIndex = -1;
    private long rememberedFilePointer = -1;
    private boolean rememberedEOF = false;

    public PrintUtils(String file) {
        fileName = file;
        try {
            // Open file
            raf = new RandomAccessFile(file, "r");
        } catch (Exception e) {
            rememberedEOF = true;
        }
    }

    public PrintUtils() {
        this(futils.Futil.getReadFileName("select a file to print"));
    }

    public static void printFile() {
        PrinterJob job = PrinterJob.getPrinterJob();
        // Specify the Printable is an instance of SimplePrint
        job.setPrintable(new PrintUtils());
        // Put up the dialog box
        if (job.printDialog()) {
            // Print the job if the user didn't cancel printing
            try {
                job.print();
            } catch (Exception e) { /* handle exception */
                e.printStackTrace();
            }
        }
        System.exit(0);
    }


    public int print2(Graphics g, PageFormat pf, int pageIndex)
            throws PrinterException {
        try {
            // For catching IOException
            if (pageIndex != rememberedPageIndex) {
                // First time we've visited this page
                rememberedPageIndex = pageIndex;
                // If encountered EOF on previous page, done
                if (rememberedEOF) return Printable.NO_SUCH_PAGE;
                // Save current position in input file
                rememberedFilePointer = raf.getFilePointer();
            } else
                raf.seek(rememberedFilePointer);
            g.setColor(Color.black);
            g.setFont(fnt);
            int x = (int) pf.getImageableX() + 10;
            int y = (int) pf.getImageableY() + 12;
            // Title line
            g.drawString("File: " +
                    fileName +
                    ", page: " +
                    (pageIndex + 1), x, y);
            // Generate as many lines as will fit in imageable area
            y += 36;
            while (y + 12 < pf.getImageableY() + pf.getImageableHeight()) {
                String line = raf.readLine();
                if (line == null) {
                    rememberedEOF = true;
                    break;
                }
                g.drawString(line, x, y);
                y += 12;
            }
            return Printable.PAGE_EXISTS;
        } catch (Exception e) {
            return Printable.NO_SUCH_PAGE;
        }
    }


    private Component componentToBePrinted;

    public static void printComponent(Component c) {
        new PrintUtils(c).print();
    }

    public PrintUtils(Component componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog())
            try {
                printJob.print();
            } catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
    }

    public int print(Graphics g,
                     PageFormat pageFormat,
                     int pageIndex) {
        if (pageIndex > 0) {
            return (NO_SUCH_PAGE);
        } else {
            Graphics2D g2d = (Graphics2D) g;
            g2d.translate(pageFormat.getImageableX(),
                    pageFormat.getImageableY());
            disableDoubleBuffering(componentToBePrinted);
            componentToBePrinted.paint(g2d);
            enableDoubleBuffering(componentToBePrinted);
            return (PAGE_EXISTS);
        }
    }

    /**
     * The speed and quality of printing suffers dramatically if any of the
     * containers have double buffering turned on. So this turns if off
     * globally.
     *
     */
    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    /**
     * Re-enables double buffering globally.
     */

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}


