package addBk.midtermAddressBook;

// AddressBookDatabase

import java.awt.*;
import java.io.*;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.beans.XMLEncoder;

public class AddressBookDatabase
        implements Serializable {
    private Vector addressVector = new Vector();
    private int recordNumber = 0;

    public AddressBookDatabase() {
        addRecord(new AddressBookRecord());
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(baos);
        e.writeObject(this);
        e.flush();
        return baos.toString();
    }

    public void sort() {
        //System.out.println("sorting");
        //***** Un comment on JDK 1.2 or better to sort
        //Collections.sort(v);
    }

    public AddressBookRecord getEmptyDbRecord() {
        AddressBookRecord abr =
                new AddressBookRecord();
        abr.name = "--- Empty Database ---";
        abr.address =
                "Use the <File> menu to\n <Open> a database object,\n <Merge> a CSV file";
        abr.notes = "Or use the [EDIT] button to\n [Add Record]s to the empty DB";
        abr.dial_1 = "";
        abr.dial_2 = "";
        abr.dial_3 = "";
        return (abr);
    }

    public AddressBookRecord readRecord() {
        return (AddressBookRecord) addressVector.elementAt(recordNumber);
    }

    public AddressBookRecord readRecord(int recNumber) {
        return (AddressBookRecord) addressVector.elementAt(recNumber);
    }


    public void addRecord(AddressBookRecord abr) {
        addressVector.addElement(abr);
        recordNumber = addressVector.size() - 1;
    }

    public void deleteRecord(AddressBookRecord abr) {
        addressVector.removeElement(abr);
    }


    public void saveCurrentRecord(AddressBookRecord abr) {
        try {
            addressVector.setElementAt(abr, recordNumber);
        } catch (ArrayIndexOutOfBoundsException e) {

        }
    }
    public int getNumRecords() {
        return (addressVector.size());
    }
    public void deleteCurrentRecord() {
        addressVector.removeElementAt(recordNumber);
    }

    public void incrementRecord() {
        if (recordNumber < (addressVector.size() - 1))
            recordNumber++;
        System.out.println(recordNumber);
    }

    public void decrementRecord() {
        if (recordNumber > 0)
            recordNumber--;
        System.out.println(recordNumber);
    }

    public void setRecordNumber(int index) {
        if ((index >= 0) && (index <= addressVector.size()))
            recordNumber = index;
        System.out.println(recordNumber);
    }

    public void openDb() {
        try {
            System.out.println("Opening Address Db Object");
            readDbObject(); 	// gzip format
            //readFromFile();	// object w/o gzip
        } catch (IOException e) {
            System.out.println("IOException");
        } catch (ClassNotFoundException e) {
            System.out.println("ClassNotFoundException");
        }
    }

    public void saveDb() {
        try {
            System.out.println("Saving Address Db Object");
            saveDbObject();		// gzip format
            //writeToFile();	// object w/o gzip
        } catch (IOException e) {
            System.out.println("IOERROR: " + e.getMessage());
        }
    }

    public void writeToFile() throws IOException {
        FileOutputStream outStream = new FileOutputStream("junkobj");
        System.out.println("FileOutputStream OK");
        ObjectOutputStream ooStream = new ObjectOutputStream(outStream);
        System.out.println("ObjectOutputStream OK");
        ooStream.writeObject(this);
        ooStream.flush();
        ooStream.close();
        outStream.close();
    } // writeToFile()

    public void readFromFile() throws IOException, ClassNotFoundException {
        FileInputStream inStream = new FileInputStream("junkobj");
        ObjectInputStream oiStream = new ObjectInputStream(inStream);
        AddressBookDatabase abd = (AddressBookDatabase) oiStream.readObject();
        this.addressVector = abd.addressVector;
    } // readFromFile()

    public void readDbObject() throws IOException
            , ClassNotFoundException {
        System.out.println("starting read...");
        FileInputStream fis
                = new FileInputStream(Futil.getReadFileName("Select input file"));
        GZIPInputStream gis
                = new GZIPInputStream(fis);
        ObjectInputStream ois
                = new ObjectInputStream(gis);
        AddressBookDatabase abd = (AddressBookDatabase) ois.readObject();
        this.addressVector = abd.addressVector;
        ois.close();
        gis.close();
        fis.close();
        System.out.println("restored v.size: " + this.addressVector.size());
    }// readObject


    public void saveDbObject() throws IOException {
        System.out.println("starting save...");
        FileOutputStream fos
                = new FileOutputStream(Futil.getWriteFileName("Select output file"));
        GZIPOutputStream gos
                = new GZIPOutputStream(fos);
        ObjectOutputStream oos
                = new ObjectOutputStream(gos);
        oos.writeObject(this);
        System.out.println("working with save...");
        oos.flush();
        oos.close();
        gos.finish();
        fos.close();
        System.out.println("done with save...");
        System.out.println("saved v.size: " + this.addressVector.size());
    }

    public Vector getAddressVector() {
        return addressVector;
    }

    public void setAddressVector(Vector addressVector) {
        this.addressVector = addressVector;
    }

    static class Futil {
        public static String getReadFileName(
                String prompt) {
            FileDialog fd = new FileDialog(
                    new Frame(), prompt);
            fd.setVisible(true);
            fd.setVisible(false);
            return fd.getDirectory() + fd.getFile();
        }

        public static String getWriteFileName(
                String prompt) {
            FileDialog fd = new FileDialog(
                    new Frame(), prompt, FileDialog.SAVE);
            fd.setVisible(true);
            fd.setVisible(false);
            return fd.getDirectory() + fd.getFile();
        }
    }

}