package addBk.jdbcAddressBook;

import gui.run.RunButton;
import gui.run.RunLabel;
import gui.run.RunTextField;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 23, 2005
 * Time: 8:28:54 PM
 * Copyright DocJava, 2005
 */
public class AddressRecordEditor implements PropertyEditor {
    private AddressRecord addressRecord = new AddressRecord();


    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public static void main(String[] args) {
        AddressRecordEditor are = new AddressRecordEditor();
        are.display();

    }

    private JDialog display() {
        if (!(supportsCustomEditor())) return null;
        addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("prop change");
            }
        });
        Component comp = getCustomEditor();
        JDialog jd = new JDialog();
        jd.setModal(false);
        Container c = jd.getContentPane();
        c.add(comp);

        jd.setSize(200, 100);
        jd.pack();
        jd.setVisible(true);
        return jd;
    }

    public Component getCustomEditor() {
        JPanel jp = new JPanel();
        jp.add(new RunLabel("[First Name"));
        jp.add(new RunTextField("[First Name", 20) {
            public void run() {
                System.out.println(getText());
                addressRecord.setFirstName(getText());
            }
        });
        jp.add(new RunLabel("[Last Name"));
        jp.add(new RunTextField("[Last Name", 20) {
            public void run() {
                System.out.println(getText());
                addressRecord.setLastName(getText());
            }
        });
        jp.add(new RunButton("ok") {
            public void run() {
                addressRecord.update();
            }
        });
        return jp;
    }

    //todo: get a record from a custom editor
    //Hint: a modal dialog might be good for this.
    private AddressRecord promptUserForAddressRecord() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        addressRecord.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        addressRecord.removePropertyChangeListener(listener);

    }

    public Object getValue() {
        return addressRecord;
    }

    public void setValue(Object newValue) {
        AddressRecord newRecord = (AddressRecord) newValue;
        if (addressRecord.equals(newRecord)) return;

        addressRecord = newRecord;
        addressRecord.update();
    }

    // todo: implement a CSV output for the getter.
    public String getAsText() {
        return addressRecord.toString();
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    // todo: implement a CSV input for the
    // setter.
    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}
