package addBk.jdbcAddressBook;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.TextEvent;

public class AddressPanel extends JPanel
        implements AddressSettable {

    public void textValueChanged(TextEvent e) {
        System.out.println(e);
    }

    public void setAddress(AddressRecord a) {
        ta1.setText(a.getAddress1());
        ta2.setText(a.getAddress2());
    }

    JTextArea ta2 = getTextArea("address2",'b');
    JTextArea ta1 = getTextArea("address1",'a');

    AddressPanel() {
        setLayout(new GridLayout(0,1));
        add(ta1,BorderLayout.NORTH);
        add(ta2,BorderLayout.SOUTH);

    }

    private JTextArea getTextArea(String label,char accelerator) {
        JTextArea ta1 = new JTextArea(5,30);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(label);
        ta1.setBorder(titledBorder);
        ta1.setToolTipText(label);
        ta1.setFocusAccelerator(accelerator);
        ta1.setLineWrap(true);
        ta1.setEditable(true);
        return ta1;
    }
}