package addBk.jdbcAddressBook;

import gui.ClosableJFrame;
import gui.run.RunMenu;
import gui.run.RunMenuItem;

import javax.swing.*;
import java.awt.*;

import xml.adbk.AddressBook;

public class AddressBookFrame
        extends ClosableJFrame
        implements AddressSettable {
    Help help = new Help();
    AddressBook adbk = new AddressBook();
    AddressPanel ap =
            new AddressPanel();
    TextButtonPanel tbp =
            new TextButtonPanel();
    JTextField nameField =
            new JTextField("Name Field");
    LabelSelectorPanel lsp =
            new LabelSelectorPanel();

    public void setAddress(AddressRecord a) {
        ap.setAddress(a);
        tbp.setAddress(a);
        nameField.setText(a.getName());
        repaint();
    }

    public void init() {
        Container c = getContentPane();
        c.setLayout(new BorderLayout());
        c.add(nameField, "North");
        c.add(ap, "Center");
        c.add(tbp, "South");
        setJMenuBar(getMenuBar2());
        setSize(300, 300);
        setVisible(true);

    }

    public  JMenuBar getMenuBar2() {
        JMenuBar mb = new JMenuBar();
        mb.add(getFileMenu());
        return mb;
    }

    public  RunMenu getFileMenu() {
        RunMenu fileMenu = new RunMenu("[File");
        fileMenu.add(new RunMenuItem("[open{control o}") {
            public void run() {
                adbk.open();
            }
        });
        fileMenu.add(new RunMenuItem("[save as csv{control s}") {
            public void run() {
                adbk.saveAsCsv();
            }
        });
        fileMenu.add(new RunMenuItem("[x save as xml{control x}") {
            public void run() {
                adbk.saveAsXml();
            }
        });
        fileMenu.add(new RunMenuItem("[Help{control h}") {
            public void run() {
                help.display();
            }
        });
        return fileMenu;
    }

    public static void main(String args[]) {
        AddressBookFrame
                adf = new AddressBookFrame();
        adf.init();

    }
}
