package addBk.awtAddressBook;

//AddressDisplay.java


public class AddressBookMediator {
    private static AddressBookRecord storageRecord;
    private static boolean editFlag = false;
    private static boolean emptyDb = true;

    private static AddressBookFrame adf =
            new AddressBookFrame();
    private static AddressBookDatabase abd =
            new AddressBookDatabase();
    private static AddressBookMediator display =
            getAddressDisplay();
    private final AddressBookFrame addressBookFrame =
            new AddressBookFrame();

    public static void setTextFieldValues(
            AddressBookRecord abr) {
        getAdf().getTf().setText(abr.name);
        getAdf().getAp().t0.setText(abr.address);
        getAdf().getAp().t1.setText(abr.notes);
        getAdf().getTbp().tfp.t0.setText(
                abr.dial_1);
        getAdf().getTbp().tfp.t1.setText(
                abr.dial_2);
        getAdf().getTbp().tfp.t2.setText(
                abr.dial_3);
        getAdf().getEditPanel().tfp.t0.setText(
                abr.dial_1);
        getAdf().getEditPanel().tfp.t1.setText(
                abr.dial_2);
        getAdf().getEditPanel().tfp.t2.setText(
                abr.dial_3);
    }

    public AddressBookRecord getTextFieldValues() {
        AddressBookRecord abr =
                new AddressBookRecord();
        abr.name = getAdf().getTf().getText();
        abr.address =
        getAdf().getAp().t0.getText();
        abr.notes =
        getAdf().getAp().t1.getText();
        if (!AddressBookFrame.isEditMode()) {
            abr.dial_1 =
            getAdf().getTbp().tfp.t0.getText();
            abr.dial_2 =
            getAdf().getTbp().tfp.t1.getText();
            abr.dial_3 =
            getAdf().getTbp().tfp.t2.getText();
        } else {
            abr.dial_1 =
            getAdf().getEditPanel().tfp.t0.getText();
            abr.dial_2 =
            getAdf().getEditPanel().tfp.t1.getText();
            abr.dial_3 =
            getAdf().getEditPanel().tfp.t2.getText();
        }
        return (abr);
    }

    public void nextRecord() {
        getAbd().incrementRecord();
        setStorageRecord((getAbd().readRecord()));
        AddressBookMediator.setTextFieldValues(
                getAbd().readRecord());
    }

    public void prevRecord() {
        getAbd().decrementRecord();
        setStorageRecord((getAbd().readRecord()));
        AddressBookMediator.setTextFieldValues(
                getAbd().readRecord());
    }

    public void addRecord() {
        AddressBookRecord abr = getAddressDisplay()
                .getTextFieldValues();
        getAbd().addRecord(abr);
        setStorageRecord((getAbd().readRecord()));
        getAdf().getIndexPanel().indexList.add(
                abr.name);
        getAddressDisplay().setIndexItems();
        AddressBookMediator.setEditFlag(false);
    }

    public void deleteCurrentRecord() {
        getAbd().deleteCurrentRecord();
        getAddressDisplay().setIndexItems();
        AddressBookMediator.setEditFlag(false);
        setStorageRecord((getAbd().readRecord()));
    }

    public void saveCurrentRecord() {

        getAbd().saveCurrentRecord(
                getTextFieldValues());
        getAbd().sort();
        getAddressDisplay().setIndexItems();
        setStorageRecord((getAbd().readRecord()));
        AddressBookMediator.setEditFlag(false);
    }

    public void revertRecord() {
        getAbd().saveCurrentRecord(
                getStorageRecord());
        setStorageRecord((getAbd().readRecord()));
        AddressBookMediator.setTextFieldValues(
                getAbd().readRecord());
        AddressBookMediator.setEditFlag(false);
    }

    public void setEditFlag() {
        AddressBookMediator.setEditFlag(true);
    }

    public void toggleIndexDisplay() {
        if (AddressBookFrame.isIndexToggle() ==
            true) {
            AddressBookFrame.setIndexToggle(
                    false);
            getAdf().init();
        } else {
            AddressBookFrame.setIndexToggle(true);
            getAdf().init();
        }
    }

    public void setIndexItems() {
        getAdf().getIndexPanel().indexList.removeAll();
        for (int i = 0; i <
                        (getAbd().getNumRecords()); i++) {
            AddressBookRecord abr = getAbd()
                    .readRecord(i);
            getAdf().getIndexPanel().indexList.add(
                    abr.name);
        } // end for
    }

    public void setRecord(int i) {
        getAbd().setRecordNumber(i);
        AddressBookRecord abr = getAbd()
                .readRecord();
        AddressBookMediator.setTextFieldValues(
                abr);
        setStorageRecord((getAbd().readRecord()));
    }

    public void toggleEditPanel() {
        if (AddressBookFrame.isEditMode() ==
            true) {
            AddressBookFrame.setEditMode(false);
            getAdf().getTf().setEditable(false);
            getAdf().getAp().t0.setEditable(
                    false);
            getAdf().getAp().t1.setEditable(
                    false);
            getAdf().init();
            System.out.println("Edit mode OFF");
        } else {
            AddressBookFrame.setEditMode(true);
            getAdf().getTf().setEditable(true);
            getAdf().getAp().t0.setEditable(true);
            getAdf().getAp().t1.setEditable(true);
            getAdf().init();
            System.out.println("Edit mode ON");

            if (isEmptyDb()) {
                // auto add record in edit mode when none
                AddressBookRecord abr =
                        new AddressBookRecord();
                abr.name = "new record";
                AddressBookMediator.setTextFieldValues(
                        abr);
                getAddressDisplay().addRecord();
                setEmptyDb(false);
            }

        }
    }

    public void dbMerge() {
        new CSVMerge(getAbd());
        getAbd().sort();
        getAddressDisplay().setRecord(0);
        getAddressDisplay().setIndexItems();
        setEmptyDb(false);
    }

    public void dbExport() {
        new CSVExport(getAbd());
    }

    public void dbOpen() {
        getAbd().openDb();
        AddressBookMediator.setTextFieldValues(
                getAbd().readRecord());
        getAddressDisplay().setRecord(0);
        getAddressDisplay().setIndexItems();
        setEmptyDb(false);
    }

    public void dbSave() {
        getAbd().saveDb();
    }

    public static AddressBookRecord getStorageRecord() {
        return storageRecord;
    }

    public static void setStorageRecord(
            AddressBookRecord storageRecord) {
        AddressBookMediator.storageRecord =
        storageRecord;
    }

    public static boolean isEditFlag() {
        return editFlag;
    }

    public static void setEditFlag(
            boolean editFlag) {
        AddressBookMediator.editFlag = editFlag;
    }

    public static boolean isEmptyDb() {
        return emptyDb;
    }

    public static void setEmptyDb(
            boolean emptyDb) {
        AddressBookMediator.emptyDb = emptyDb;
    }

    public static AddressBookFrame getAdf() {
        return adf;
    }

    public static void setAdf(
            AddressBookFrame adf) {
        AddressBookMediator.adf = adf;
    }

    public static AddressBookDatabase getAbd() {
        return abd;
    }

    public static void setAbd(
            AddressBookDatabase abd) {
        AddressBookMediator.abd = abd;
    }

    public static AddressBookMediator getAddressDisplay() {
        if (display == null) display =
                             new AddressBookMediator();
        return display;
    }

    public AddressBookFrame getAddressBookFrame() {
        return addressBookFrame;
    }


}
