package xml.adbk;

import futils.CsvParser;
import futils.ReaderUtil;
import futils.SerialUtils;
import futils.WriterUtil;
import gui.html.HtmlSynthesizer;

import java.io.*;
import java.util.Collections;
import java.util.Vector;

/**
 * xml.AddressBook is responsible for holding
 * Address instances and converting them to XML or
 * CSV format.
 */
//todo: make sortable.

public class AddressBook
        implements Serializable {
    private int recordNumber = 0;
    public Vector v = new Vector();
    // v is a vector of address instances.
    public String dtd =
            "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>\n" +
            "<!DOCTYPE AddressBook [\n" +
            "    <!ELEMENT Address (\n" +
            "		(title | firstName| lastName | userId | password)*,\n" +
            "		(streetAddress|address1 | address2| address3 )*,\n" +
            "		(homePage | emailAddress)*,\n" +
            "		(homePhone | businessPhone | faxPhone)*,\n" +
            "		city,\n" +
            "		state,\n" +
            "		zip?)>\n" +
            "    <!ELEMENT title (#PCDATA)>\n" +
            "    <!ELEMENT firstName (#PCDATA)>\n" +
            "    <!ELEMENT lastName (#PCDATA)>\n" +
            "    <!ELEMENT address1 (#PCDATA)>\n" +
            "    <!ELEMENT address2 (#PCDATA)>\n" +
            "    <!ELEMENT address3 (#PCDATA)>\n" +
            "    <!ELEMENT streetAddress (#PCDATA)>\n" +
            "    <!ELEMENT emailAddress (#PCDATA)>\n" +
            "    <!ELEMENT homePage (#PCDATA)>\n" +
            "    <!ELEMENT city (#PCDATA)>\n" +
            "    <!ELEMENT state (#PCDATA)>\n" +
            "    <!ELEMENT zip (#PCDATA)>\n" +
            "    <!ELEMENT homePhone (#PCDATA)>\n" +
            "    <!ELEMENT businessPhone (#PCDATA)>\n" +
            "    <!ELEMENT faxPhone (#PCDATA)>\n" +
            "    <!ELEMENT AddressBook (Address*)>\n" +
            "]>\n";


    public void addAddress(Address a) {
        v.addElement(a);
    }

    public void sort() {
        System.out.println("sorting");
        //***** Un comment on JDK 1.2 or better to sort
        Collections.sort(v);
    }

    public void deleteRecord(Address abr) {
        v.removeElement(abr);
    }

    public String getAddressXml() {
        StringBuffer sb = new StringBuffer("\n");
        for (int i = 0; i < v.size(); i++)
            sb.append(((Address) v.elementAt(i)).toXml());
        return sb.toString();
    }

    public String toXml() {
        return dtd
               + "\n<AddressBook>"
               + getAddressXml()
               + "\n</AddressBook>";
    }

    public String toHtmlTable() {
        HtmlSynthesizer hs =
                new HtmlSynthesizer();
        String aa[] = new String[v.size()];
        for (int i = 0; i < v.size(); i++) {
            aa[i] =
            ((Address) v.elementAt(i)).toHtml();
        }
        return hs.getTable(hs.getSheet(aa));
    }

    public String toHtmlCsv() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.size(); i++) {
            sb.append(
                    ((Address) v.elementAt(i)).toCsv() +
                    "<p>");
        }
        return sb.toString();
    }

    public String toCsv() {
        String s = "\n";
        for (int i = 0; i < v.size(); i++)
            s =
            s +
            ((Address) v.elementAt(i)).toCsv();
        return s;
    }

    public String toString() {
        return toXml();
    }

    public void processLine(String l) {
        String[] tokens = new CsvParser(l).getTokens();
        v.addElement(new Address(tokens));
    }

    /**
     * getAddress from another addressBook and add
     * them to your vector!
     */
    public void merge(AddressBook ab) {
        Address aa[] = ab.getAddresses();
        for (int i = 0; i < aa.length; i++)
            addAddress(aa[i]);
    }

    public Address[] getAddresses() {
        Address aa[] = new Address[v.size()];
        v.copyInto(aa);
        return aa;
    }

    public void getLines(BufferedReader br) {
        try {
            for (String l = br.readLine(); l !=
                                           null; l =
                                                 br.readLine())
                processLine(l);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void open(BufferedReader br)
            throws IOException {
        getLines(br);
        br.close();
    }

    public void open() {
        try {
            open(
                    ReaderUtil.getBufferedReader(
                            "select *.csv"));
        } catch (IOException e) {
        }
    }

    public void openXmlGz() {
        try {
            String s = SerialUtils.readGzipString();
            System.out.println("Read in:" + s);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveXmlGz() {
        try {
            SerialUtils.writeGzipString(toXml());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        BufferedWriter bw =
                WriterUtil.getBufferedWriter(
                        "output xml");
        WriterUtil.println(bw, toXml());
        WriterUtil.close(bw);
    }

    public void saveAsCsv() {
        BufferedWriter bw =
                WriterUtil.getBufferedWriter(
                        "output xml");
        WriterUtil.println(bw, toCsv());
        WriterUtil.close(bw);
    }

    public void saveAsXml() {
        BufferedWriter bw =
                WriterUtil.getBufferedWriter(
                        "output xml");
        WriterUtil.println(bw, toXml());
        WriterUtil.close(bw);
    }

    public void saveAsXml(File f) {
        BufferedWriter bw =
                WriterUtil.getBufferedWriter(f);
        WriterUtil.println(bw, toXml());
        WriterUtil.close(bw);
    }

    public AddressBook search(
            String searchString) {
        Address a;
        AddressBook ab = new AddressBook();
        for (int i = 0; i < v.size(); i++) {
            a = (Address) v.elementAt(i);
            if (a.match(searchString))
                ab.addAddress(a);
        }
        return ab;
    }

    public int getNumRecords() {
        return (v.size());
    }

    public void deleteCurrentRecord() {
        v.removeElementAt(recordNumber);
    }

    public Address getPreviousAddress() {
        decrementRecord();
        return (Address) v.elementAt(
                recordNumber);
    }

    public Address getNextAddress() {
        incrementRecord();
        return (Address) v.elementAt(
                recordNumber);
    }

    public void incrementRecord() {
        if (recordNumber < (v.size() - 1))
            recordNumber++;
    }

    public void decrementRecord() {
        if (recordNumber > 0)
            recordNumber--;
    }
    public void printLastNames() {
        for (int i=0 ; i < v.size(); i++){
          Address a = (Address)  v.elementAt(i);
            System.out.println("lastName="+a.getLastName());
        }
    }

    public void setRecordNumber(int index) {
        if ((index >= 0) && (index <= v.size()))
            recordNumber = index;
        System.out.println(recordNumber);
    }

    public static void main(String args[]) {
        Address a = new Address();
        a.setLastName("adler");
        a.setFirstName("Joe");
        a.setCompany("Vectron");
        a.setHomePage("http://www.vectron.com");
        AddressBook ab = new AddressBook();
        ab.addAddress(a);
        ab.open();
        ab.printLastNames();

        //System.out.println(ab.toXml());
        ab.sort();
        ab.printLastNames();
        //System.out.println("ab=" + ab.toXml());
        //ab.saveXmlGz();
        //ab.openXmlGz();
    }

}
