package video;

/**
 * Created by
 * User: lyon
 * Date: Nov 29, 2003
 * Time: 11:11:38 AM
 *
 */

import gui.run.RunScroll;

import javax.swing.JPanel;
import java.awt.*;
import java.awt.geom.Line2D;
import java.util.Vector;


public class SoundDigitizerPanel
        extends JPanel {
    private RunScroll topSb;
    private RunScroll bottomSb;
    private RunScroll leftSb;
    private RunScroll rightSb;

    private Vector lines = new Vector();

    private int[] doubleData;

    private int dx = 0;

    private int oldDx = 0;

    private int dy = 0;

    private int oldDy = 0;

    private final double
            xScaleFactors[] = {50000, 25000, 10000, 5000, 2500, 1000,
                               500, 250, 100, 50, 25, 10,
                               5, 2.5, 1, .5, .25, .1,
                               .05, .025, .01, .005, .0025, .001,
                               .0005};
    private final String xSFLabels[] = {"0.05 u", "0.1 u", "0.25 u",
                                        "0.5 u", "1 u", "2.5 u",
                                        "5 u", "10 u", "25 u",
                                        "50 u", "100 u", "250 u",
                                        "500 u", "1 m", "2.5 m",
                                        "5 m", "10 m", "25 m",
                                        "50 m", "100 m", "250 m",
                                        "500 m", "1 ", "2.5 ",
                                        "5 "};
    private final int xsfStartIndex = 14;
    private double xScaleFactor = xScaleFactors[xsfStartIndex];
    private double oldXScaleFactor = xScaleFactors[xsfStartIndex];
    private String xSFLabel = new String(xSFLabels[xsfStartIndex]);
    private boolean labelsVisible = true;
    private String title = null;


    public void setLabelsVisible(boolean b) {
        labelsVisible = b;
    }

    public static final double
            yScaleFactors[] = {
                50000,
                25000,
                10000,
                5000,
                2000,
                1000,
                500,
                200,
                100,
                50,
                20,
                10,
                5, 2, 1, .5, .2, .1};
    public static final String
            ySFLabels[] = {
                "1 m", "2.5 m",
                "5 m", "10 m",
                "25 m", "50 m",
                "100 m", "250 m",
                "500 m",
                "1 ", "2.5 ",
                "5 ", "10 ",
                "20 ", "50 ",
                "100 ", "250 ", "500 "};
    private final int yScaleFactorStartIndex = 8;
    private double yScaleFactor = 1;
    private double oldYScaleFactor = 1;
    private String ySFLabel = new String(ySFLabels[yScaleFactorStartIndex]);
    private int x;
    private TracePanel tracePanel = new TracePanel();

    /**
     * This constructor uses a 440 Hz sine wave
     * as the default waveform.
     */
      public SoundDigitizerPanel(int data[]) {
              x =1;
                digitizer(data);

    }

     public RunScroll getTopSb() {
        return topSb;
    }


    public RunScroll getBottomSb() {
        return bottomSb;
    }


    public RunScroll getLeftSb() {
        return leftSb;
    }

    public RunScroll getRightSb() {
        return rightSb;
    }

    public Component getTracePanel() {
        return tracePanel;
    }

    public void setTopSb(RunScroll topSb) {
        this.topSb = topSb;
    }
    public Dimension getMinimumSize() {
        System.out.println("min size called in dp");
        return getPreferredSize();
    }

    public Dimension getPreferredSize() {
        System.out.println("preffered size in dp called");
        return new Dimension(400, 200);
    }

    /**
     * A read only variable
     *
     * @return the title as set by the constructor
     */
    public String getTitle() {
        return title;
    }

    /**
     * This constructor uses the <code>doubleData</code>
     * as the source for the default waveform.
     *
     * @param doubleData an array of data to be displayed
     //* @param title      title of the panel.
     */
    //public OscopePanel(double doubleData[], String title) {
    public void digitizer(final int doubleData[]) {

        checkTheData(doubleData);
        this.doubleData = doubleData;


        topSb =
                new RunScroll(Scrollbar.HORIZONTAL) {
                    public void run() {
                        int i = getValue();
                        xScaleFactor = xScaleFactors[i];
                        if (xScaleFactor != oldXScaleFactor) {
                            xSFLabel = xSFLabels[i];
                            tracePanel.repaint(500);
                            oldXScaleFactor = xScaleFactor;

                        }
                    }
                };
        // Set top scrollbar characteristics
        topSb.setValues(xsfStartIndex, 0, 0, 24);


        bottomSb =
                new RunScroll(Scrollbar.HORIZONTAL) {

                    public void run() {

                        dx = getValue()*2;
                        if (dx != oldDx) {

                            tracePanel.repaint(500);
                            oldDx = dx;
                        }
                    }
                };

        leftSb =
                new RunScroll(Scrollbar.VERTICAL) {
                    public void run() {
                        dy = getValue()*2;
                        if (dy != oldDy) {
                            tracePanel.repaint(500);
                            oldDy = dy;
                        }
                    }
                };


        rightSb =
                new RunScroll(Scrollbar.VERTICAL) {
                    public void run() {
                        int i = getValue();
                        yScaleFactor = yScaleFactors[i];
                        if (yScaleFactor != oldYScaleFactor) {
                            ySFLabel = ySFLabels[i];
                            tracePanel.repaint(500);
                            oldYScaleFactor = yScaleFactor;
                        }
                    }
                };
        // Set right scrollbar characteristics
        rightSb.setValues(yScaleFactorStartIndex, 0, 0,
                yScaleFactors.length - 1);

       bottomSb.setValues(0, 0, 0,88864);
        // Set left scrollbar characteristics
        leftSb.setValues(0, 0, -3000, 3000);
        if (x==1){
         setLayout(new BorderLayout());
        add(topSb, BorderLayout.NORTH);
         add(bottomSb, BorderLayout.SOUTH);
         add(leftSb, BorderLayout.WEST);
         add(rightSb, BorderLayout.EAST);
         add(tracePanel, BorderLayout.CENTER);
         setBackground(Color.white);
         x =2;
        }
        // Sxet bottom scrollbar characteristics based on sample length


    }

    private void checkTheData(int[] doubleData) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i=0; i < doubleData.length; i++) {
            int dat = doubleData[i];
            if (dat < min) min = dat;
            if (dat > max) max = dat;

        }
        System.out.println("min="+min);
        System.out.println("max="+max);
    }

    class TracePanel extends JPanel {
        private boolean drawGrid = true;
        private Color gridColor = new Color(0, 255, 0);
        private Dimension dim;
        private int height, width;

        public void setGridColor(Color c) {
            gridColor = c;
        }

        public Dimension getMinimumSize() {
            System.out.println("tracePanel min size called");
            return new Dimension(200, 200);
        }

        public Dimension getPreferredSize() {
            System.out.println("preferredSize called");
            return new Dimension(200,200);
        }

        public void grid(int grid_spacing, Graphics g, Color c) {
            Rectangle r = g.getClipBounds();
            int w = r.width;
            int h = r.height;
            Color oldColor = g.getColor();
            g.setColor(c);
            for (int x = 0; x < w; x = x + grid_spacing) {
                g.drawLine(x, 0, x, h);
            }
            for (int y = 0; y < h; y = y + grid_spacing) {
                g.drawLine(0, y, w, y);
            }
            g.setColor(oldColor);
        }

        public void paint(Graphics g) {

            drawData(g);
            if (!labelsVisible) return;
            drawXScaleLabel(g);

            drawYScaleLabel(g);

        }


        private void drawData(Graphics gOld) {

            Graphics2D g = (Graphics2D) gOld;
            double limit = (doubleData.length * xScaleFactor);
            dim = getSize();
            height = dim.height;
            width = dim.width;
            g.clearRect(0, 0, width, height);
            if (drawGrid)
                grid(20, g, gridColor);


            if (limit > width) limit = (double) width;
            int j = dx;
            done:
            for (double i = 0; i < limit; i += xScaleFactor) {
                if (j >= (doubleData.length - 1))
                    break done;
                double x1 = i;
                double y1 = (height - (
                        ( doubleData[j]  * yScaleFactor)
                        * height / 400 + height / 200 ))- dy;
                double x2 = (i + xScaleFactor);
                double y2 = (height - (
                        ((doubleData[j + 1]) * yScaleFactor)
                        * height / 400 + height / 200)) - dy;

                g.draw(new Line2D.Double(x1, y1/2 , x2, y2/2));

                g.setColor(Color.red);

                j++;
            }
        }


        private void drawXScaleLabel(Graphics g) {
            g.setColor(Color.black);
            int height = 10;
            int xloc = 20;
            int yloc = 20;
            String xsfLabel = xSFLabel + "sec/div";
            int string_width = getFontMetrics(g.getFont()).stringWidth(xsfLabel);
            int string_height = getFontMetrics(g.getFont()).getHeight();
            g.clearRect(xloc, yloc, string_width, string_height);
            g.drawString(xsfLabel, xloc, height + yloc);
        }

        private void drawYScaleLabel(Graphics g) {
            g.setColor(Color.red);
            int height = 10;
            int xloc = 20;
            int yloc = dim.height - 60;
            String ysfLabel = ySFLabel + "v/div";
            int string_width = getFontMetrics(g.getFont()).stringWidth(ysfLabel);
            int string_height = getFontMetrics(g.getFont()).getHeight();
            g.clearRect(xloc, yloc, string_width, string_height);
            g.drawString(ysfLabel, xloc, height + yloc);
        }

    }

}

