package video;

import futils.Futil;
import gui.ClosableJFrame;
import net.multicast.Utils;

import javax.imageio.ImageIO;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

/**
 * Copyright DocJava, inc.
 * User: lyon
 * Date: Oct 27, 2004
 * Time: 5:08:08 AM
 */
public class BroadcastViewerThread extends Thread {
    private MulticastSocket msocket;
    private DatagramPacket recv;

    public BroadcastViewerThread(MulticastSocket msock) {
        msocket = msock;
        setDaemon(false);
        start();                // start calls run
    }

    public void run() {
        byte[] buf = new byte[100000];
        String tmp;
        ImageFrame imgFrame = new ImageFrame();
        imgFrame.setVisible(true);
        try {
            while (true) {
                // Handle the incoming data and print it to stnd output.
                recv = new DatagramPacket(buf, buf.length);
                msocket.receive(recv);
                byte[] data = recv.getData();
                int length = recv.getLength();
                InetAddress address = recv.getAddress();
                ByteArrayInputStream bais =
                        new ByteArrayInputStream(buf, 0, data.length);
                imgFrame.getImage(bais);
                System.out.println("\n\nRecived: \"" +
                        "ip=" + address +
                        "\"\nMessage Length is: " +
                        length);
            }
        } catch (IOException e) {
            System.out.println("Exit...");
            e.printStackTrace();
        } finally {
            msocket.close();
        }
    }

    public static void testGetADataGram() {
        byte inbuf[] = new byte[2 >> 64];
        while (true) {
            int n = getADataGram(inbuf);
            System.out.println("got:" + n + "bytes");
        }
    }

    public static int getADataGram(byte inbuf[]) {
        try {
            int port = 1234;
            MulticastSocket socket = new MulticastSocket();
            final InetAddress multicastGroup = Utils.getInetAddress();
            socket.joinGroup(multicastGroup);
            DatagramPacket dp = new DatagramPacket(inbuf,
                    inbuf.length,
                    multicastGroup,
                    port);
            System.out.println("dp=" + dp.getAddress() + ":" + dp.getPort());
            System.out.println("isMulticastAddress=" +
                    multicastGroup.isMulticastAddress());
            socket.receive(dp);
            socket.leaveGroup(multicastGroup);
            socket.close();
            // Data is now in inbuf
            return dp.getLength();
        } catch (SocketException e) {
        } catch (IOException e) {
        }
        return -1;
    }

    public static void showImages() throws IOException {
        InetAddress inetAddress = Utils.getInetAddress();
        int port = 1234;
        byte[] buf = new byte[100000];
        byte ba[] = null;
        DatagramPacket dp = null;
        ImageFrame cf = new ImageFrame();
        cf.show();
        MulticastSocket mcastSocket =
                Utils.getMulticastSocket(port, inetAddress);
        while (true) {
            // Handle the incoming data and print it to stnd output.
            dp = new DatagramPacket(buf, buf.length);
            mcastSocket.receive(dp);
            ba = dp.getData();
            System.out.println("got data, len=" + buf.length);
            ByteArrayInputStream bais =
                    new ByteArrayInputStream(buf, 0, ba.length);
            cf.getImage(bais);
        }
    }

    public static void testImageFrame() {
        ImageFrame imFr = new ImageFrame();
        imFr.setSize(200, 200);
        imFr.setVisible(true);
        imFr.getImage();
    }

    public static class ImageFrame extends ClosableJFrame {
        private BufferedImage img = null;

        public void getImage() {
            try {
                File f = Futil.getReadFile("select an image file");
                getImage(f);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void getImage(File f) throws IOException {
            FileInputStream fis = new FileInputStream(f);
            getImage(fis);
        }

        public void getImage(InputStream is) throws IOException {
            BufferedImage bi = ImageIO.read(is);
            is.close();
            setImage(bi);
        }

        public void setImage(BufferedImage bi) {
            img = bi;
            setSize(bi.getWidth(), bi.getHeight());
            repaint();
        }

        public void paint(Graphics g) {
            if (img == null) {
                g.drawString("no data rcvd", 0, this.getHeight() / 2);
                 return;
            }
            ;
            Graphics2D g2d = (Graphics2D) g;
            g2d.drawImage(img, null, 0, 0);
        }
    }
}
