package video;

import futils.Futil;
import futils.ReaderUtil;
import gui.In;
import net.multicast.Utils;

import javax.imageio.ImageIO;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 25, 2004
 * <p/>
 * Time: 6:24:58 AM
 */
public class Broadcast {
    public static void main(String[] args) throws IOException {
        int port = 2435;
        InetAddress inetAddress = Utils.getInetAddress();

        try {
            MulticastSocket mcastSocket =
                    Utils.getMulticastSocket(port, inetAddress);
            mcastSocket.setLoopbackMode(true);
            new BroadcastViewerThread(mcastSocket);
            if(In.getBoolean("do you want to broadcast?"))
                transmitData(mcastSocket, inetAddress, port);
        } catch (Exception err) {
            err.printStackTrace();
        }
    }

    private static void transmitData(MulticastSocket mcastSocket, InetAddress inetAddress, int port) throws IOException, AWTException, InterruptedException {
        Rectangle rect = In.getRectangle("select a region to capture");
        for (; ;) {
            final long now = System.currentTimeMillis();
            sendBytes(mcastSocket, inetAddress, port, getBytesToSend(rect));
            long delta = System.currentTimeMillis() - now;
            final long minTime = 250;
            if (delta < minTime)
                Thread.sleep(minTime-delta);
        }
    }

    public static byte[] getBytesToSend(Rectangle rect) throws IOException, AWTException {
        byte b[] = Broadcast.grabAPngImage(rect);
        return b;
    }

    public static void sendBytes(MulticastSocket mcastSocket,
                                 InetAddress inetAddress,
                                 int port, byte b[]) {
        DatagramPacket dp = new DatagramPacket(b,
                b.length,
                inetAddress,
                port);
        if (b.length > 12280) System.out.println("danger, datagram="+b.length);
/*
The following is a well known bug in windows:
On Microsoft Windows 95 and Microsoft Windows 98 datagrams
sent and received via the loopback address are limited to 12280 bytes.
If an application attempts to use DatagramSocket.send to send a
DatagramPacket with a length greater than 12280 bytes to the
loopback address the DatagramSocket.send method will throw a
SocketException with the following text:
    "The message is larger than the maximum supported by the underlying transport"
*/
        try {
            mcastSocket.send(dp);
        } catch (IOException e) {
            e.printStackTrace();

        }
    }

    private static void sendAFile(InetAddress inetAddress,
                                  int port,
                                  MulticastSocket mcastSocket) {
        System.out.println("SendAFile_");
        File f = Futil.getReadFile("select a text file");
        sendAFile(f,
                inetAddress,
                port,
                mcastSocket);
    }

    private static void sendAFile(File f,
                                  InetAddress inetAddress,
                                  int port,
                                  MulticastSocket mcastSocket) {
        try {
            String sa[] = ReaderUtil.getFile(f);
            byte b[] = ReaderUtil.getBytes(sa);
            DatagramPacket dp = new DatagramPacket(b,
                    b.length,
                    inetAddress,
                    port);
            mcastSocket.send(dp);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void testSendADataGram() {
        int port = 1234;
        InetAddress dst = null;
        byte outbuf[] = new byte[100];
        int len = outbuf.length;
        for (int i = 0; i < 100; i++) {
            sendADataGram(port, outbuf, len);
        }
    }

    public static void sendADataGram(int port,
                                     byte[] outbuf,
                                     int len) {
        try {
            final InetAddress inetAddress = Utils.getInetAddress();
            DatagramPacket dp = new DatagramPacket(outbuf,
                    len,
                    inetAddress,
                    port);
            System.out.println("dp=" + dp.getAddress() + ":" + dp.getPort());
            MulticastSocket socket = new MulticastSocket();
            socket.send(dp);
            socket.close();
        } catch (SocketException e) {
        } catch (IOException e) {
        }
    }

    public static void broadcastImages() {
        try {
            broadcastImages(In.getInt("select the number " +
                    "of images to capture"));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * broadcast png images using udp multicast packets.
     *
     * @param n number of images to send.
     * @throws java.io.IOException
     */
    public static void broadcastImages(int n) throws IOException {
        final InetAddress inetAddress = Utils.getInetAddress();
        final int port = 1234;
        final Rectangle rect = In.getRectangle("select a capture area");
        final MulticastSocket mcastSocket =
                Utils.getMulticastSocket(port, inetAddress);
        for (int i = 0; i < n; i++) {
            try {
                sendAnImage(mcastSocket, port, inetAddress, rect, i);
                sleep(1000);
            } catch (IOException e) {
                e.printStackTrace();
            } catch (AWTException e) {
                e.printStackTrace();
            }
        }
        Utils.closeSocket(mcastSocket, inetAddress);
        System.out.println("done xmitting");
    }

    private static void sleep(long i) {
        try {
            Thread.sleep(i);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void sendAnImage(MulticastSocket mcastSocket, int port,
                                    InetAddress inetAddress,
                                    Rectangle rect, int i)
            throws IOException, AWTException {
        byte b[] = grabAPngImage(rect);
        DatagramPacket dp = new DatagramPacket(b,
                b.length,
                inetAddress,
                port);
        mcastSocket.send(dp);
        System.out.println("sent image:" + i);
    }

    /**
     * grab a screen capture in png format.
     *
     * @param rect
     * @throws java.awt.AWTException
     * @throws java.io.IOException
     */
    public static byte[] grabAPngImage(Rectangle rect)
            throws AWTException, IOException {
        // create screen shot
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Robot robot = new Robot();
        BufferedImage image = robot.createScreenCapture(rect);
        // save captured image to PNG file
        ImageIO.write(image, "png", baos);
        baos.close();
        return baos.toByteArray();
    }
}
