/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Oct 1, 2003
 * Time: 1:08:41 PM
 * To change this template use Options | File Templates.
 */
package sound.soundDemo;

import java.awt.*;

public class Key extends Rectangle {

    int kNum;
    private MidiSynth midiSynth;
    int noteState = midiSynth.OFF;

    public Key(MidiSynth midiSynth, int x, int y, int width, int height, int num) {
        super(x, y, width, height);
        this.midiSynth = midiSynth;

        kNum = num;
    }

    public boolean isNoteOn() {
        return noteState == midiSynth.ON;
    }

    public void on() {
        setNoteState(midiSynth.ON);
        midiSynth.cc.channel.noteOn(kNum, midiSynth.cc.velocity);
        if (midiSynth.record) {
            midiSynth.createShortEvent(midiSynth.NOTEON, kNum);
        }
    }

    public void off() {
        setNoteState(midiSynth.OFF);
        midiSynth.cc.channel.noteOff(kNum, midiSynth.cc.velocity);
        if (midiSynth.record) {
            midiSynth.createShortEvent(midiSynth.NOTEOFF, kNum);
        }
    }

    public void setNoteState(int state) {
        noteState = state;
    }
} // End class Key
