package sound.soundDemo;
// sound.soundDemo.JavaSound

/*
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


import javax.sound.midi.MidiSystem;
import javax.sound.sampled.AudioSystem;
import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;


/**
 * The Java Sound Samples : MidiSynth, Juke, CapturePlaybackPanel, Groove.
 *
 * @version @(#)JavaSound.java	1.17 02/02/06
 * @author Brian Lichtenwalter
 */
public class JavaSound implements ChangeListener, Runnable {

    Vector demoVector = new Vector(4);
    JTabbedPane tabPane = new JTabbedPane();
    int width = 760, height = 500;
    int index;
    private final MyJPanel jPanel = new MyJPanel();

    public MyJPanel getPanel() {
        return jPanel;
    }


    public JavaSound(String audioDirectory) {

        jPanel.setLayout(new BorderLayout());

        JMenuBar menuBar = new JMenuBar();

        if (JavaSoundApplet.applet == null) {
            JMenu fileMenu = (JMenu) menuBar.add(new JMenu("File"));
            JMenuItem item = (JMenuItem) fileMenu.add(new JMenuItem("Exit"));
            item.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        JMenu options = (JMenu) menuBar.add(new JMenu("Options"));
        JMenuItem item = (JMenuItem) options.add(new JMenuItem("Applet Info"));
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                showInfoDialog();
            }
        });
        jPanel.add(menuBar, BorderLayout.NORTH);

        tabPane.addChangeListener(this);

        EmptyBorder eb = new EmptyBorder(5, 5, 5, 5);
        BevelBorder bb = new BevelBorder(BevelBorder.LOWERED);
        CompoundBorder cb = new CompoundBorder(eb, bb);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new CompoundBorder(cb, new EmptyBorder(0, 0, 90, 0)));
        final Juke juke = new Juke(audioDirectory);
        p.add(juke);
        demoVector.add(juke);
        tabPane.addTab("Juke Box", p);

        new Thread(this).start();

        jPanel.add(tabPane, BorderLayout.CENTER);
    }


    public void stateChanged(ChangeEvent e) {
        close();
        System.gc();
        index = tabPane.getSelectedIndex();
        open();
    }


    public void close() {
        ((ControlContext) demoVector.get(index)).close();
    }


    public void open() {
        ((ControlContext) demoVector.get(index)).open();
    }


    public static void showInfoDialog() {
        final String msg =
                "When running the Java Sound demo as an applet these permissions\n" +
                "are necessary in order to load/save files and record audio :  \n\n" +
                "grant { \n" +
                "  permission java.io.FilePermission \"<<ALL FILES>>\", \"read, write\";\n" +
                "  permission javax.sound.sampled.AudioPermission \"record\"; \n" +
                "  permission java.util.PropertyPermission \"user.dir\", \"read\";\n" +
                "}; \n\n" +
                "The permissions need to be added to the .java.policy file.";
        new Thread(new Runnable() {
            public void run() {
                JOptionPane.showMessageDialog(null, msg, "Applet Info", JOptionPane.INFORMATION_MESSAGE);
            }
        }).start();
    }


    /**
     * Lazy load the tabbed pane with CapturePlaybackPanel, MidiSynth and Groove.
     */
    public void run() {
        EmptyBorder eb = new EmptyBorder(5, 5, 5, 5);
        BevelBorder bb = new BevelBorder(BevelBorder.LOWERED);
        CompoundBorder cb = new CompoundBorder(eb, bb);
        addCapturePlaybackPanel();
        JPanel p;
        MidiSynth midiSynth = new MidiSynth();
        demoVector.add(midiSynth);
        tabPane.addTab("Midi Synthesizer", midiSynth);

        p = new JPanel(new BorderLayout());
        p.setBorder(new CompoundBorder(cb, new EmptyBorder(0, 0, 5, 20)));
        Groove groove = new Groove();
        demoVector.add(groove);
        p.add(groove);
        tabPane.addTab("Groove Box", p);
    }

    private void addCapturePlaybackPanel() {
        JPanel p = getCapturePlaybackPanel();
        tabPane.addTab("Capture/Playback", p);
    }

    public  JPanel getCapturePlaybackPanel() {
        JPanel p = new JPanel(new BorderLayout());

        CapturePlaybackPanel capturePlaybackPanel = new CapturePlaybackPanel();
        demoVector.add(capturePlaybackPanel);
        p.add(capturePlaybackPanel);
        return p;
    }

    public static void main(String[] args) {

        checkAudio();

        String media = "media";
        if (args.length > 0) {
            File file = new File(args[0]);
            if (file == null && !file.isDirectory()) {
                System.out.println("usage: java JavaSound audioDirectory");
            } else {
                media = args[0];
            }
        }

        final JavaSound demo = new JavaSound(media);
        JFrame f = new JFrame("Java Sound Demo");
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent e) {
                demo.open();
            }

            public void windowIconified(WindowEvent e) {
                demo.close();
            }
        });
        f.getContentPane().add("Center", demo.jPanel);
        f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        f.setLocation(d.width / 2 - demo.width / 2, d.height / 2 - demo.height / 2);
        f.setSize(new Dimension(demo.width, demo.height));
        f.setVisible(true);
    }

    private static void checkAudio() {
        try {
            if (MidiSystem.getSequencer() == null) {
                System.err.println("MidiSystem Sequencer Unavailable, exiting!");
                System.exit(1);
            } else if (AudioSystem.getMixer(null) == null) {
                System.err.println("AudioSystem Unavailable, exiting!");
                System.exit(1);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private class MyJPanel extends JPanel {
        public Dimension getPreferredSize() {
            return new Dimension(JavaSound.this.width, JavaSound.this.height);
        }
    }
}
