package sound.musica;

import gui.ExitFrame;
import java.awt.Container;
import javax.sound.midi.Synthesizer;
import javax.swing.JLabel;
import sound.Scales;
import sound.StochasticControl;
import sound.Utils;


public class Main extends KeyProcessor {
    static class MouseFrame extends ExitFrame {
        MouseFrame() {
            Container c = getContentPane();

            MusicMouseListener mp
                    = new MusicMouseListener();
            KeyProcessor kp
                    = new KeyProcessor();
            c.addMouseMotionListener(mp);
            c.addMouseListener(mp);
            addKeyListener(kp);
            c.add(new JLabel("musica"));
            setSize(300, 300);
            setVisible(true);
        }
    }

    public static void main(String args[]) {
        new MouseFrame();
        StochasticControl.randomNotes(sound.Scales.getScale(
                Scales.HARMONIC_MINOR, 32, 74),
                                      10);
    }


    public static void testNote() {
        int nNoteNumber = 64;	// MIDI key number
        int nVelocity = 127;   //0..127
        int nDuration = 500;   // ms
        Synthesizer synth = Utils.getSynthesizer();
        Utils.play(synth,
                   nNoteNumber,
                   nVelocity,
                   nDuration);
    }

}