package sound.fd;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Residue.java

import java.io.Serializable;
import java.util.Vector;

public class Residue
        implements Serializable {

    public Residue() {
        polynom = new Polynom();
        ready = false;
    }

    public double[] getQuotient() {
        return quotient;
    }

    public boolean getReadiness() {
        return ready;
    }

    public double getDelta() {
        return delta;
    }

    public Complex[] rootsToPoly(int i) {
        Vector vector = new Vector();
        for (int j = 0; j < roots.length; j++)
            if (j != i) {
                Complex complex = roots[j];
                for (int k = 0; k < repeat[j]; k++)
                    vector.addElement(new Complex(complex, 1));

            }

        Complex acomplex[];
        if (vector.size() == 0) {
            acomplex = new Complex[1];
            acomplex[0] = new Complex(1.0D, 0.0D);
        } else {
            acomplex = new Complex[vector.size() + 1];
            for (int l = 0; l < acomplex.length; l++)
                acomplex[l] = new Complex();

            acomplex[0] = new Complex(1.0D);
            acomplex[1] = new Complex((Complex) vector.elementAt(0));
            for (int i1 = 1; i1 < vector.size(); i1++) {
                Complex complex1 = new Complex(
                        (Complex) vector.elementAt(i1));
                for (int j1 = i1 + 1; j1 > 0; j1--)
                    acomplex[j1] =
                            acomplex[j1 - 1].mul(complex1).add(
                                    acomplex[j1]);

            }

        }
        return acomplex;
    }

    public void purgeRoot(Vector vector) {
        Vector vector1 = new Vector();
        repeat = new int[vector.size()];
        for (int i = 0; i < vector.size(); i++) {
            Complex complex = (Complex) vector.elementAt(i);
            vector1.addElement(new Complex(complex.real, complex.imag));
            repeat[i] = 1;
            for (int j = i + 1; j < vector.size(); j++)
                if (complex.equals((Complex) vector.elementAt(j))) {
                    vector.removeElementAt(j);
                    j--;
                    repeat[i]++;
                }

        }

        roots = new Complex[vector1.size()];
        for (int k = 0; k < vector1.size(); k++)
            roots[k] = (Complex) vector1.elementAt(k);

        vector1 = null;
        Object obj = null;
    }

    public void partial(double ad[], double ad1[], Vector vector) {
        purgeRoot(vector);
        polynom.divide(ad, ad1);
        double ad2[] = polynom.getQuotient();
        quotient = new double[ad2.length];
        System.arraycopy(ad2, 0, quotient, 0, ad2.length);
        ad2 = polynom.getRest();
        rest = new double[ad2.length];
        System.arraycopy(ad2, 0, rest, 0, ad2.length);
        coeffs = new Complex[roots.length][];
        for (int i = 0; i < roots.length; i++) {
            Complex acomplex1[] = new Complex[rest.length];
            for (int j = 0; j < rest.length; j++)
                acomplex1[j] = new Complex(rest[j], 0.0D);

            Complex acomplex[] = rootsToPoly(i);
            coeffs[i] = new Complex[repeat[i]];
            for (int k = 0; k < coeffs[i].length; k++) {
                if (k > 0) {
                    polynom.derive(acomplex1, acomplex);
                    acomplex1 = polynom.getNumeratorCmpl();
                    acomplex = polynom.getDenominatorCmpl();
                }
                coeffs[i][repeat[i] - k - 1] =
                        polynom.evaluate(acomplex1, acomplex, roots[i])
                        .div(polynom.factorial(k));
                coeffs[i][repeat[i] - k - 1].cleanMe();
            }

        }

        if (quotient.length > 0)
            delta = quotient[quotient.length - 1];
        else
            delta = 0.0D;
        ready = true;
    }

    public static void main(String args[]) {
        Residue residue = new Residue();
        double ad[] = {
            1.0D, 2D, -3D
        };
        double ad1[] = {
            1.0D, 2D
        };
        Vector vector = new Vector();
        vector.addElement(new Complex(-2D, 0.0D));
        residue.partial(ad, ad1, vector);
        for (int i = 0; i < residue.coeffs.length; i++) {
            for (int j = 0; j < residue.coeffs[i].length; j++)
                System.out.println(
                        "\n Root = " +
                        roots[i] +
                        " " +
                        residue.coeffs[i][j]);

        }

        System.out.println(String.valueOf(residue.getDelta()));
    }

    double quotient[];
    double rest[];
    public static Complex roots[];
    public Complex coeffs[][];
    Polynom polynom;
    private int repeat[];
    boolean ready;
    double delta;
}
