package sound.fd;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ParamFrame.java

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class ParamFrame extends Frame
        implements ActionListener {

    public ParamFrame(PlotCanvasBean plotcanvasbean) {
        super("Set Parameters");
        setSize(500, 200);
        setResizable(false);
        setVisible(false);
        plotCanvas = plotcanvasbean;
        setLayout(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        xMin = new Label("Min frequency  ", 2);
        xMax = new Label("Max frequency  ", 2);
        yMagMin = new Label("Min Magnitude  ", 2);
        yMagMax = new Label("Max Magnitude  ", 2);
        yPhaMin = new Label("Min Phase  ", 2);
        yPhaMax = new Label("Max Phase  ", 2);
        precise = new Label("Precision (1-300)  ", 2);
        gain = new Label("Gain  ", 2);
        error =
                new Label(
                        "There are no errors for now but it could happen !!!",
                        1);
        minFreq = new TextField(5);
        maxFreq = new TextField(5);
        minMag = new TextField(5);
        maxMag = new TextField(5);
        minPhase = new TextField(5);
        maxPhase = new TextField(5);
        precision = new TextField(5);
        gainField = new TextField(5);
        okButton = new Button("OK");
        cancelButton = new Button("Cancel");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(4, 4));
        panel.add(xMin);
        panel.add(minFreq);
        panel.add(xMax);
        panel.add(maxFreq);
        panel.add(yMagMin);
        panel.add(minMag);
        panel.add(yMagMax);
        panel.add(maxMag);
        panel.add(yPhaMin);
        panel.add(minPhase);
        panel.add(yPhaMax);
        panel.add(maxPhase);
        panel.add(precise);
        panel.add(precision);
        panel.add(gain);
        panel.add(gainField);
        gridbagconstraints.gridy = 0;
        add(panel, gridbagconstraints);
        Panel panel1 = new Panel();
        panel1.add(okButton);
        panel1.add(cancelButton);
        gridbagconstraints.gridy = 1;
        add(error, gridbagconstraints);
        gridbagconstraints.gridy = 2;
        add(panel1, gridbagconstraints);
        validate();
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        minFreq.addActionListener(this);
        maxFreq.addActionListener(this);
        minMag.addActionListener(this);
        maxMag.addActionListener(this);
        minPhase.addActionListener(this);
        maxPhase.addActionListener(this);
        precision.addActionListener(this);
        gainField.addActionListener(this);
        addWindowListener(new WindowAdapter() {

            public void windowClosing(WindowEvent windowevent) {
                setVisible(false);
            }

        });
        error.setText("");
    }

    public void wake() {
        para = plotCanvas.oldParams();
        x1 = ((Double) para.elementAt(0)).doubleValue();
        x2 = ((Double) para.elementAt(1)).doubleValue();
        y1 = ((Double) para.elementAt(2)).doubleValue();
        y2 = ((Double) para.elementAt(3)).doubleValue();
        y3 = ((Double) para.elementAt(4)).doubleValue();
        y4 = ((Double) para.elementAt(5)).doubleValue();
        p = ((Integer) para.elementAt(6)).intValue();
        g = ((Double) para.elementAt(7)).doubleValue();
        minFreq.setText(String.valueOf(x1));
        maxFreq.setText(String.valueOf(x2));
        minMag.setText(String.valueOf(y1));
        maxMag.setText(String.valueOf(y2));
        minPhase.setText(String.valueOf(y3));
        maxPhase.setText(String.valueOf(y4));
        precision.setText(String.valueOf(p));
        gainField.setText(String.valueOf(g));
        error.setText(
                "Still a big long enormous string, just because things are strange in this world");
        setVisible(true);
        error.setText("");
    }

    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj == cancelButton) {
            setVisible(false);
            return;
        }
        try {
            x1 = (new Double(minFreq.getText())).doubleValue();
            x2 = (new Double(maxFreq.getText())).doubleValue();
            y1 = (new Double(minMag.getText())).doubleValue();
            y2 = (new Double(maxMag.getText())).doubleValue();
            y3 = (new Double(minPhase.getText())).doubleValue();
            y4 = (new Double(maxPhase.getText())).doubleValue();
            p = (new Integer(precision.getText())).intValue();
            g = (new Double(gainField.getText())).doubleValue();
            if (x1 >= x2 ||
                    y1 >= y2 ||
                    y3 >= y4 ||
                    p < 1 ||
                    p > 300 ||
                    x1 < 0.0D ||
                    x2 < 0.0D) {
                throw new MyException("Please, insert correct values !!!");
            } else {
                para = new Vector();
                para.addElement(new Double(x1));
                para.addElement(new Double(x2));
                para.addElement(new Double(y1));
                para.addElement(new Double(y2));
                para.addElement(new Double(y3));
                para.addElement(new Double(y4));
                para.addElement(new Integer(p));
                para.addElement(new Double(g));
                error.setText("");
                plotCanvas.newParams(para);
                setVisible(false);
                return;
            }
        } catch (MyException myexception) {
            error.setText(myexception.getMessage());
            return;
        } catch (NumberFormatException _ex) {
            error.setText(
                    "A number is something with digits (0..9), thanks.");
        }
    }

    double x1;
    double x2;
    double y1;
    double y2;
    double y3;
    double y4;
    double g;
    int p;
    Label xMin;
    Label xMax;
    Label yMagMin;
    Label yMagMax;
    Label yPhaMin;
    Label yPhaMax;
    Label precise;
    Label gain;
    Label error;
    TextField minFreq;
    TextField maxFreq;
    TextField minMag;
    TextField maxMag;
    TextField minPhase;
    TextField maxPhase;
    TextField precision;
    TextField gainField;
    Button okButton;
    Button cancelButton;
    PlotCanvasBean plotCanvas;
    Vector para;
}
