package sound.fd;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   MyMouseBean.java

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;

public class MyMouseBean extends Canvas
        implements Serializable, MouseListener, MyMouseListener {

    public MyMouseBean() {
        title = "";
        myMouseListeners = new Vector();
        pcs = new PropertyChangeSupport(this);
        X = Y = 0.0D;
        format = 1;
        setBackground(Color.white);
        setForeground(Color.black);
        setFont(new Font("Dialog", 0, 12));
        setCursor(new Cursor(1));
        addMouseListener(this);
    }

    public synchronized void paint(Graphics g) {
        update(g);
    }

    public synchronized void update(Graphics g) {
        Dimension dimension = getSize();
        if (offGraphics == null ||
                dimension.width != offDimension.width ||
                dimension.height != offDimension.height) {
            offDimension = dimension;
            offImage = createImage(dimension.width, dimension.height);
            offGraphics = offImage.getGraphics();
        }
        offGraphics.setColor(getBackground());
        offGraphics.fillRect(0,
                0,
                offDimension.width,
                offDimension.height);
        width = getSize().width;
        height = getSize().height;
        offGraphics.setColor(Color.black);
        FontMetrics fontmetrics = g.getFontMetrics();
        int i = fontmetrics.getMaxAscent() - fontmetrics.getMaxDescent();
        offGraphics.drawString(title,
                (width - fontmetrics.stringWidth(title)) / 2,
                i + 2);
        offGraphics.drawLine(0, i + 4, width, i + 4);
        offGraphics.drawString("X = " + convert(X), 3, i * 2 + 10);
        offGraphics.drawString("Y = " + convert(Y), 3, i * 3 + 15);
        offGraphics.drawRect(0, 0, width - 1, height - 1);
        g.drawImage(offImage, 0, 0, this);
    }

    public String convert(double d) {
        switch (format) {
            case 1: // '\001'
                return String.valueOf(d);

            case 2: // '\002'
                return "";

            case 3: // '\003'
                return "";

            case 4: // '\004'
                return "";

            case 5: // '\005'
                return "";

            case 6: // '\006'
                return "";

            case 7: // '\007'
                return "";
        }
        return "";
    }

    public void mouseOccured(MyMouseEvent mymouseevent) {
        setTitle(mymouseevent.getTitle());
        X = mymouseevent.getX();
        Y = mymouseevent.getY();
        repaint();
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public synchronized void addMyMouseListener(
            MyMouseListener mymouselistener) {
        myMouseListeners.addElement(mymouselistener);
    }

    public synchronized void removeMyMouseListener(
            MyMouseListener mymouselistener) {
        myMouseListeners.removeElement(mymouselistener);
    }

    public void addPropertyChangeListener(
            PropertyChangeListener propertychangelistener) {
        pcs.addPropertyChangeListener(propertychangelistener);
    }

    public void removePropertyChangeListener(
            PropertyChangeListener propertychangelistener) {
        pcs.removePropertyChangeListener(propertychangelistener);
    }

    public void setFontSize(int i) {
        Font font = getFont();
        setFont(new Font(font.getName(), font.getStyle(), i));
        pcs.firePropertyChange("fontSize",
                new Integer(font.getSize()),
                new Integer(i));
    }

    public void setFont(Font font) {
        Font font1 = getFont();
        super.setFont(font);
        pcs.firePropertyChange("font", font1, font);
    }

    public void setBackground(Color color) {
        Color color1 = getBackground();
        super.setBackground(color);
        pcs.firePropertyChange("background", color1, color);
    }

    public void setForeground(Color color) {
        Color color1 = getForeground();
        super.setForeground(color);
        pcs.firePropertyChange("foreground", color1, color);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String s) {
        title = s;
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    private String title;
    private double X;
    private double Y;
    int format;
    int height;
    int width;
    private Dimension offDimension;
    private transient Image offImage;
    private transient Graphics offGraphics;
    private Vector myMouseListeners;
    private PropertyChangeSupport pcs;
}
