package sound.fd;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ControlBean.java

import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ControlBean
        implements BodeListener, Serializable, AutoscaleListener {

    public synchronized void addBodeListener(BodeListener bodelistener) {
        bodeListeners.addElement(bodelistener);
    }

    public synchronized void addAutoscaleListener(
            AutoscaleListener autoscalelistener) {
        autoscaleListeners.addElement(autoscalelistener);
    }

    public synchronized void removeBodeListener(BodeListener bodelistener) {
        bodeListeners.removeElement(bodelistener);
    }

    public synchronized void removeAutoscaleListener(
            AutoscaleListener autoscalelistener) {
        autoscaleListeners.removeElement(autoscalelistener);
    }

    public void fireBodeEvent(BodeEvent bodeevent) {
        Vector vector = null;
        synchronized (this) {
            vector = (Vector) bodeListeners.clone();
        }
        for (int i = 0; i < vector.size(); i++) {
            BodeListener bodelistener = (BodeListener) vector.elementAt(i);
            bodelistener.changeOccured(bodeevent);
        }

    }

    public void fireAutoscaleEvent(AutoscaleEvent autoscaleevent) {
        Vector vector = null;
        synchronized (this) {
            vector = (Vector) autoscaleListeners.clone();
        }
        for (int i = 0; i < vector.size(); i++) {
            AutoscaleListener autoscalelistener = (AutoscaleListener) vector.elementAt(
                    i);
            autoscalelistener.autoscaleOccured(autoscaleevent);
        }

    }

    public void changeOccured(BodeEvent bodeevent) {
        switch (bodeevent.getType()) {
            case 0: // '\0'
                pole.addElement(new Pole((Pole) bodeevent.getRoot()));
                break;

            case 1: // '\001'
                zero.addElement(new Zero((Zero) bodeevent.getRoot()));
                break;

            case 2: // '\002'
                ((Pole) pole.elementAt(bodeevent.getPosition())).setPos(
                        bodeevent.getRoot().getReal(),
                        bodeevent.getRoot().getImag());
                break;

            case 3: // '\003'
                ((Zero) zero.elementAt(bodeevent.getPosition())).setPos(
                        bodeevent.getRoot().getReal(),
                        bodeevent.getRoot().getImag());
                break;

            case 4: // '\004'
                pole.removeElementAt(bodeevent.getPosition());
                break;

            case 5: // '\005'
                zero.removeElementAt(bodeevent.getPosition());
                break;

            case 6: // '\006'
                zero.removeAllElements();
                pole.removeAllElements();
                break;

            case 7: // '\007'
                Vector vector = bodeevent.getPoles();
                gain = bodeevent.getGain();
                synchronized (this) {
                    if (vector != null) {
                        pole.removeAllElements();
                        for (int i2 = 0; i2 < vector.size(); i2++)
                            pole.addElement(
                                    new Pole((Pole) vector.elementAt(i2)));

                    }
                }
                break;

            case 8: // '\b'
                Vector vector1 = bodeevent.getZeros();
                gain = bodeevent.getGain();
                synchronized (this) {
                    if (vector1 != null) {
                        zero.removeAllElements();
                        for (int j2 = 0; j2 < vector1.size(); j2++)
                            zero.addElement(
                                    new Zero((Zero) vector1.elementAt(j2)));

                    }
                }
                break;

            case 9: // '\t'
                Vector vector2 = bodeevent.getPoles();
                Vector vector9 = bodeevent.getZeros();
                gain = bodeevent.getGain();
                synchronized (this) {
                    if (vector2 != null) {
                        pole.removeAllElements();
                        for (int k2 = 0; k2 < vector2.size(); k2++)
                            pole.addElement(
                                    new Pole((Pole) vector2.elementAt(k2)));

                    }
                    if (vector9 != null) {
                        zero.removeAllElements();
                        for (int l2 = 0; l2 < vector9.size(); l2++)
                            zero.addElement(
                                    new Zero((Zero) vector9.elementAt(l2)));

                    }
                }
                break;

            case 10: // '\n'
                Vector vector3 = new Vector();
                Vector vector10 = bodeevent.getPoles();
                for (int i = 0; i < vector10.size(); i++)
                    vector3.insertElementAt(
                            new ComplexNumber(
                                    ((Double) vector10.elementAt(i)).doubleValue()),
                            0);

                gain = ((ComplexNumber) vector3.elementAt(0)).getReal();
                vector3 = findRoots(vecToArray(vector3));
                pole = purgeRoot(vector3, false);
                fireBodeEvent(new BodeEvent(this, pole, gain, 7));
                break;

            case 11: // '\013'
                Vector vector4 = new Vector();
                Vector vector11 = bodeevent.getZeros();
                for (int j = 0; j < vector11.size(); j++)
                    vector4.insertElementAt(
                            new ComplexNumber(
                                    ((Double) vector11.elementAt(j)).doubleValue()),
                            0);

                gain = ((ComplexNumber) vector4.elementAt(0)).getReal();
                vector4 = findRoots(vecToArray(vector4));
                zero = purgeRoot(vector4, true);
                fireBodeEvent(new BodeEvent(this, zero, gain, 8));
                break;

            case 12: // '\f'
                Vector vector5 = new Vector();
                Vector vector12 = bodeevent.getZeros();
                for (int k = 0; k < vector12.size(); k++)
                    vector5.insertElementAt(
                            new ComplexNumber(
                                    ((Double) vector12.elementAt(k)).doubleValue()),
                            0);

                gain = ((ComplexNumber) vector5.elementAt(0)).getReal();
                vector5 = findRoots(vecToArray(vector5));
                zero = purgeRoot(vector5, true);
                vector5 = new Vector();
                vector12 = bodeevent.getPoles();
                for (int l = 0; l < vector12.size(); l++)
                    vector5.insertElementAt(
                            new ComplexNumber(
                                    ((Double) vector12.elementAt(l)).doubleValue()),
                            0);

                gain /= ((ComplexNumber) vector5.elementAt(0)).getReal();
                vector5 = findRoots(vecToArray(vector5));
                pole = purgeRoot(vector5, false);
                fireBodeEvent(new BodeEvent(this, pole, zero, gain, 9));
                break;

            case 13: // '\r'
                Vector vector6 = new Vector();
                for (int i1 = 0; i1 < bodeevent.poles.length; i1++)
                    vector6.insertElementAt(
                            new ComplexNumber(bodeevent.poles[i1]), 0);

                gain = bodeevent.poles[0];
                vector6 = findRoots(vecToArray(vector6));
                pole = purgeRoot(vector6, false);
                fireBodeEvent(new BodeEvent(this, pole, gain, 7));
                break;

            case 14: // '\016'
                Vector vector7 = new Vector();
                for (int j1 = 0; j1 < bodeevent.zeros.length; j1++)
                    vector7.insertElementAt(
                            new ComplexNumber(bodeevent.zeros[j1]), 0);

                gain = bodeevent.zeros[0];
                vector7 = findRoots(vecToArray(vector7));
                zero = purgeRoot(vector7, true);
                fireBodeEvent(new BodeEvent(this, zero, gain, 8));
                break;

            case 15: // '\017'
                Vector vector8 = new Vector();
                for (int k1 = 0; k1 < bodeevent.zeros.length; k1++)
                    vector8.insertElementAt(
                            new ComplexNumber(bodeevent.zeros[k1]), 0);

                gain = bodeevent.zeros[0];
                if (vector8.size() > 1) {
                    vector8 = findRoots(vecToArray(vector8));
                    zero = purgeRoot(vector8, true);
                }
                vector8 = new Vector();
                for (int l1 = 0; l1 < bodeevent.poles.length; l1++)
                    vector8.insertElementAt(
                            new ComplexNumber(bodeevent.poles[l1]), 0);

                gain /= bodeevent.poles[0];
                if (vector8.size() > 1) {
                    vector8 = findRoots(vecToArray(vector8));
                    pole = purgeRoot(vector8, false);
                }
                fireBodeEvent(new BodeEvent(this, pole, zero, gain, 9));
                break;
        }
        if (bodeevent.getType() < 10)
            fireBodeEvent(bodeevent);
        if (bodeevent.getType() != 9 && bodeevent.getType() != 15)
            fireBodeEvent(new BodeEvent(this, pole, zero, gain, 16));
    }

    public void autoscaleOccured(AutoscaleEvent autoscaleevent) {
        fireAutoscaleEvent(autoscaleevent);
    }

    public static Vector purgeRoot(Vector vector, boolean flag) {
        Vector vector1 = new Vector();
        for (int i = 0; i < vector.size(); i++) {
            ComplexNumber complexnumber = (ComplexNumber) vector.elementAt(
                    i);
            if (flag)
                vector1.addElement(
                        new Zero(complexnumber.getReal() / 100000D,
                                complexnumber.getImag() / 100000D));
            else
                vector1.addElement(
                        new Pole(complexnumber.getReal() / 100000D,
                                complexnumber.getImag() / 100000D));
            for (int j = i + 1; j < vector.size(); j++) {
                ComplexNumber complexnumber1 = (ComplexNumber) vector.elementAt(
                        j);
                if (complexnumber.getReal() == complexnumber1.getReal() &&
                        complexnumber.getImag() ==
                        -complexnumber1.getImag() &&
                        complexnumber.getImag() != 0.0D)
                    vector.removeElementAt(j);
            }

        }

        return vector1;
    }

    public static Vector findRoots(ComplexNumber acomplexnumber[]) {
        Vector vector = new Vector();
        int i = acomplexnumber.length - 1;
        ComplexNumber acomplexnumber2[] = new ComplexNumber[acomplexnumber.length];
        ComplexNumber acomplexnumber1[] = new ComplexNumber[i + 1];
        ComplexNumber complexnumber = new ComplexNumber();
        for (int k = 0; k <= i; k++)
            acomplexnumber2[k] = acomplexnumber[k];

        if (i <= 1) {
            vector.addElement(
                    acomplexnumber[0].div(acomplexnumber[1]).scale(
                            -100000D));
            return vector;
        }
        for (int l = i; l >= 1; l--) {
            ComplexNumber complexnumber1 = new ComplexNumber(
                    -100D * Math.random(), -100D * Math.random());
            complexnumber1 =
                    findARoot(acomplexnumber2, l, complexnumber1);
            if (Math.abs(complexnumber1.getImag()) <=
                    3.9999999999999998E-06D *
                    Math.abs(complexnumber1.getReal()))
                complexnumber1.setImag(0.0D);
            acomplexnumber1[l] = complexnumber1;
            ComplexNumber complexnumber3 = new ComplexNumber(
                    acomplexnumber2[l]);
            for (int l1 = l - 1; l1 >= 0; l1--) {
                ComplexNumber complexnumber4 = new ComplexNumber(
                        acomplexnumber2[l1]);
                acomplexnumber2[l1] = complexnumber3;
                complexnumber3 =
                        complexnumber4.add(
                                complexnumber1.mul(complexnumber3));
            }

        }

        for (int i1 = 1; i1 <= i; i1++) {
            ComplexNumber complexnumber5 = new ComplexNumber(
                    acomplexnumber1[i1]);
            acomplexnumber1[i1] =
                    findARoot(acomplexnumber, i, complexnumber5);
        }

        for (int j1 = 2; j1 <= i; j1++) {
            int i2 = 0;
            ComplexNumber complexnumber2 = new ComplexNumber(
                    acomplexnumber1[j1]);
            for (int j = j1 - 1; j >= 1; j--) {
                ComplexNumber complexnumber6 = new ComplexNumber(
                        acomplexnumber1[j]);
                i2 = j;
                if (complexnumber6.getReal() <= complexnumber2.getReal())
                    break;
                acomplexnumber1[j + 1] = acomplexnumber1[j];
            }

            acomplexnumber1[i2 + 1] = complexnumber2;
        }

        for (int k1 = 1; k1 < acomplexnumber1.length; k1++) {
            double d = Math.round(acomplexnumber1[k1].real * 100000D);
            double d1 = Math.round(acomplexnumber1[k1].imag * 100000D);
            ComplexNumber complexnumber7 = new ComplexNumber(d, d1);
            acomplexnumber1[k1 - 1] = complexnumber7;
        }

        for (int j2 = 0; j2 < acomplexnumber1.length - 1; j2++)
            vector.addElement(acomplexnumber1[j2]);

        return vector;
    }

    public static ComplexNumber findARoot(ComplexNumber acomplexnumber[],
                                          int i,
                                          ComplexNumber complexnumber) {
        double ad[] = {
            0, 0.5D, 0.25D, 0.75D, 0.13D, 0.38D, 0.62D, 0.88D, 1.0D
        };
        ComplexNumber complexnumber1 = new ComplexNumber();
        ComplexNumber complexnumber3 = new ComplexNumber();
        ComplexNumber complexnumber8 = new ComplexNumber();
        ComplexNumber complexnumber10 = new ComplexNumber();
        ComplexNumber complexnumber12 = new ComplexNumber();
        ComplexNumber complexnumber14 = new ComplexNumber();
        ComplexNumber complexnumber16 = new ComplexNumber();
        ComplexNumber complexnumber18 = new ComplexNumber();
        for (int j = 1; j <= 80; j++) {
            ComplexNumber complexnumber5 = new ComplexNumber(
                    acomplexnumber[i]);
            double d3 = complexnumber5.abs();
            ComplexNumber complexnumber6 = new ComplexNumber();
            ComplexNumber complexnumber7 = new ComplexNumber();
            double d = complexnumber.abs();
            for (int k = i - 1; k >= 0; k--) {
                complexnumber7 =
                        complexnumber6.add(
                                complexnumber7.mul(complexnumber));
                complexnumber6 =
                        complexnumber5.add(
                                complexnumber6.mul(complexnumber));
                complexnumber5 =
                        acomplexnumber[k].add(
                                complexnumber5.mul(complexnumber));
                d3 = complexnumber5.abs() + d * d3;
            }

            d3 *= 9.9999999999999995E-08D;
            if (complexnumber5.abs() <= d3)
                return complexnumber;
            ComplexNumber complexnumber9 = complexnumber6.div(
                    complexnumber5);
            ComplexNumber complexnumber19 = complexnumber9.mul(
                    complexnumber9);
            ComplexNumber complexnumber11 = complexnumber19.sub(
                    complexnumber7.div(complexnumber5).scale(2D));
            ComplexNumber complexnumber13 = complexnumber11.scale(i)
                    .sub(complexnumber19)
                    .scale(i - 1)
                    .sqrt();
            ComplexNumber complexnumber15 = complexnumber9.add(
                    complexnumber13);
            ComplexNumber complexnumber17 = complexnumber9.sub(
                    complexnumber13);
            double d1 = complexnumber15.abs();
            double d2 = complexnumber17.abs();
            if (d1 < d2)
                complexnumber15 = complexnumber17;
            ComplexNumber complexnumber2;
            if (Math.max(d1, d2) > 0.0D) {
                complexnumber2 =
                        (new ComplexNumber(i, 0.0D)).div(complexnumber15);
            } else {
                ComplexNumber complexnumber20 = new ComplexNumber(
                        Math.cos(j), Math.sin(j));
                complexnumber2 =
                        complexnumber20.scale(
                                Math.exp(Math.log(1.0D + d)));
            }
            ComplexNumber complexnumber4 = complexnumber.sub(
                    complexnumber2);
            if (complexnumber.equals(complexnumber4))
                return complexnumber;
            if (j % 10 != 0)
                complexnumber = complexnumber4;
            else
                complexnumber =
                        complexnumber.sub(
                                complexnumber2.scale(ad[j / 10]));
        }

        return complexnumber;
    }

    public static ComplexNumber[] vecToArray(Vector vector) {
        ComplexNumber acomplexnumber[] = new ComplexNumber[vector.size()];
        int i = 0;
        for (Enumeration enumeration = vector.elements();
             enumeration.hasMoreElements();)
            acomplexnumber[i++] =
                    new ComplexNumber(
                            (ComplexNumber) enumeration.nextElement());

        return acomplexnumber;
    }

    public static Vector parseParams(String s)
            throws NumberFormatException {
        Vector vector = new Vector();
        for (StringTokenizer stringtokenizer = new StringTokenizer(s);
             stringtokenizer.hasMoreElements();
             vector.insertElementAt(
                     new ComplexNumber(
                             (new Double(stringtokenizer.nextToken())).doubleValue()),
                     0)) ;
        return vector;
    }

    public static void rootsToPoly(boolean flag) {
        Vector vector = new Vector();
        Vector vector1 = flag ? zero : pole;
        if (flag) {
            for (int i = 0; i < vector1.size(); i++) {
                Zero zero1 = new Zero((Zero) vector1.elementAt(i));
                vector.addElement(new ComplexNumber(zero1));
                if (zero1.getImag() != 0.0D)
                    vector.addElement(new ComplexNumber(zero1.conj()));
            }

            Object obj = null;
        } else {
            for (int j = 0; j < vector1.size(); j++) {
                Pole pole1 = new Pole((Pole) vector1.elementAt(j));
                vector.addElement(new ComplexNumber(pole1));
                if (pole1.getImag() != 0.0D)
                    vector.addElement(new ComplexNumber(pole1.conj()));
            }

            Object obj1 = null;
        }
        vector1 = null;
        ComplexNumber acomplexnumber[] = new ComplexNumber[vector.size() +
                1];
        for (int k = 0; k < acomplexnumber.length; k++)
            acomplexnumber[k] = new ComplexNumber();

        acomplexnumber[0] = new ComplexNumber(1.0D);
        acomplexnumber[1] =
                new ComplexNumber((ComplexNumber) vector.elementAt(0));
        for (int l = 1; l < vector.size(); l++) {
            ComplexNumber complexnumber = new ComplexNumber(
                    (ComplexNumber) vector.elementAt(l));
            for (int i1 = l + 1; i1 > 0; i1--)
                acomplexnumber[i1] =
                        acomplexnumber[i1 - 1].mul(complexnumber).add(
                                acomplexnumber[i1]);

        }

        if (flag) {
            zeroPoly = new double[acomplexnumber.length];
            for (int j1 = 0; j1 < acomplexnumber.length; j1++)
                zeroPoly[j1] = acomplexnumber[j1].getReal();

            return;
        }
        polePoly = new double[acomplexnumber.length];
        for (int k1 = 0; k1 < acomplexnumber.length; k1++)
            polePoly[k1] = acomplexnumber[k1].getReal();

    }

    public static void main(String args[]) {
    }

    public ControlBean() {
        bodeListeners = new Vector();
        autoscaleListeners = new Vector();
    }

    private static Vector pole = new Vector();
    private static Vector zero = new Vector();
    private static double polePoly[];
    private static double zeroPoly[];
    private Vector bodeListeners;
    private Vector autoscaleListeners;
    boolean done;
    double gain;

}
