package sound.fd;

// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Complex.java


class Complex {

    Complex(double d, double d1) {
        real = d;
        imag = d1;
        minimum = 1E-10D;
    }

    Complex(double d) {
        real = d;
        imag = 0.0D;
        minimum = 1E-10D;
    }

    Complex(Complex complex) {
        real = complex.getReal();
        imag = complex.getImag();
        minimum = 1E-10D;
    }

    Complex(Complex complex, int i) {
        real = -complex.getReal();
        imag = -complex.getImag();
        minimum = 1E-10D;
    }

    Complex() {
        real = 0.0D;
        imag = 0.0D;
        minimum = 1E-10D;
    }

    Complex(Root root) {
        real = -root.getReal();
        imag = -root.getImag();
        minimum = 1E-10D;
    }

    public double getImag() {
        return imag;
    }

    public double getReal() {
        return real;
    }

    public void set(double d, double d1) {
        real = d;
        imag = d1;
    }

    public void setImag(double d) {
        imag = d;
    }

    public void setReal(double d) {
        real = d;
    }

    public Complex add(Complex complex) {
        return new Complex(real + complex.getReal(),
                imag + complex.getImag());
    }

    public Complex sub(Complex complex) {
        return new Complex(real - complex.getReal(),
                imag - complex.getImag());
    }

    public Complex scale(double d) {
        return new Complex(real * d, imag * d);
    }

    public boolean equals(Complex complex) {
        return real == complex.getReal() && imag == complex.getImag();
    }

    public Complex mul(Complex complex) {
        return new Complex(
                getReal() * complex.getReal() -
                getImag() * complex.getImag(),
                getReal() * complex.getImag() +
                getImag() * complex.getReal());
    }

    public Complex mul(double d) {
        return scale(d);
    }

    public Complex div(double d) {
        return scale(1.0D / d);
    }

    public Complex div(Complex complex) {
        Complex complex1 = new Complex(this);
        div(complex1, complex.getReal(), complex.getImag());
        return complex1;
    }

    private static void div(Complex complex, double d, double d1) {
        double d2;
        double d3;
        if (Math.abs(d) >= Math.abs(d1)) {
            double d4 = 1.0D / (d + d1 * (d1 / d));
            d2 = d4 * (complex.getReal() + complex.getImag() * (d1 / d));
            d3 = d4 * (complex.getImag() - complex.getReal() * (d1 / d));
        } else {
            double d5 = 1.0D / (d * (d / d1) + d1);
            d2 = d5 * (complex.getReal() * (d / d1) + complex.getImag());
            d3 = d5 * (complex.getImag() * (d / d1) - complex.getReal());
        }
        complex.setReal(d2);
        complex.setImag(d3);
    }

    public double abs() {
        return abs(real, imag);
    }

    private static double abs(double d, double d1) {
        double d2 = Math.abs(d);
        double d3 = Math.abs(d1);
        if (d2 == 0.0D && d3 == 0.0D)
            return 0.0D;
        if (d2 >= d3) {
            double d4 = d1 / d;
            return d2 * Math.sqrt(1.0D + d4 * d4);
        } else {
            double d5 = d / d1;
            return d3 * Math.sqrt(1.0D + d5 * d5);
        }
    }

    public Complex sqrt() {
        double d1 = Math.sqrt(Math.sqrt(real * real + imag * imag));
        double d;
        if (real >= 0.0D)
            d = Math.atan(imag / real) / 2D;
        else if (imag >= 0.0D)
            d = (Math.atan(imag / real) + 3.1415926535897931D) / 2D;
        else
            d = (Math.atan(imag / real) - 3.1415926535897931D) / 2D;
        double d2 = d1 * Math.cos(d);
        double d3 = d1 * Math.sin(d);
        return new Complex(d2, d3);
    }

    public Complex conj() {
        return new Complex(real, -imag);
    }

    public Complex neg() {
        return new Complex(-real, -imag);
    }

    public Complex pow(int i) {
        double d = Math.atan(imag / real);
        if (imag == 0.0D)
            d = real <= 0.0D ? -3.1415926535897931D : 0.0D;
        if (real == 0.0D)
            d = imag <= 0.0D ? -1.5707963267948966D : 1.5707963267948966D;
        double d1 = Math.pow(abs(), i);
        return new Complex(d1 * Math.cos((double) i * d),
                d1 * Math.sin((double) i * d));
    }

    public Complex exp(Complex complex) {
        double d = Math.exp(complex.getReal());
        return new Complex(d * Math.cos(complex.getImag()),
                d * Math.sin(complex.getImag()));
    }

    public void setMinimum(double d) {
        minimum = d;
    }

    public double getMinimum() {
        return minimum;
    }

    public void cleanMe() {
        if (Math.abs(real) < minimum)
            real = 0.0D;
        if (Math.abs(imag) < minimum)
            imag = 0.0D;
    }

    public String toString() {
        if (real == 0.0D)
            return imag + "i";
        if (imag == 0.0D)
            return String.valueOf(real);
        if (imag > 0.0D)
            return real + "+" + imag + "i";
        else
            return real + "" + imag + "i";
    }

    double real;
    double imag;
    double minimum;
}
