package sound;


/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Nov 10, 2003
 * Time: 6:46:12 PM
 * To change this template use Options | File Templates.
 */

public class Voice {
    private double harmonic[] = {
        // 1,2,3,4,5,6,7 harmonics
        // range from 0..1, each
        1, 0, 1, 0, 1, 0, 1
    };

    public Voice(double _frequency) {
        frequency = _frequency;
    }

    private double frequency = 440;

    public double getFrequency() {
        return frequency;
    }

    public void setFrequency(double _d) {
        frequency = _d;
    }

    /**
     * setHamonic is called every time a new
     * voice is instanced, or the default squarewave
     * will be played.
     * @param _d
     */
    public void setHarmonic(double _d[]) {
        harmonic = _d;
    }

    public double[] mult(double d[], double a) {
        double c[] = new double[d.length];
        for (int i = 0; i < d.length; i++)
            c[i] = d[i] * a;
        return c;
    }

    public double[] add(double a[], double b[]) {
        double c[] = new double[a.length];
        for (int i = 0; i < a.length; i++)
            c[i] = a[i] + b[i];
        return c;
    }

    /**
     * This gives us all 7 harmonics together.
     * @return
     */
    public double[] getVoicedWave() {
        double h1[] = getVoicedWave(1);
        for (int i = 2; i < 8; i++)
            h1 = add(getVoicedWave(i), h1);
        return h1;
    }

    /**
     * Get the double precision voice where i is the
     * harmonic number, starting at 1 and ending at 7.
     * @param i
     * @return
     */
    public double[] getVoicedWave(int i) {
        int numberOfSamples = 16000;
        if (i < 1 || i > 7)
            System.out.println("i is out range! i=" + i);
        Oscillator o = new Oscillator(i * frequency, numberOfSamples);
        return mult(o.getSineWave(), harmonic[i - 1]);
    }

    public void play() {
        UlawCodec ulc = new UlawCodec(getVoicedWave());
        ulc.play();
    }

    public static void main(String args[]) {
        Voice v = new Voice(440);
        v.play();
    }
}
