package sound;

import java.util.Vector;


public class PetriNodes {
    private Vector v = new Vector();


    public void add(PetriNode pn) {
        v.addElement(pn);
    }

    public PetriNode getNext(PetriNode pn) {
        return getNode(pn.getNext());
    }

    void buildPetriNet() {
        for (int i = 0; i < (v.size() - 1); i++) {
            PetriNode root = getNode(i);
            root.addNext(i + 1);
            for (int j = i + 1; j < (v.size() - 1); j++) {
                PetriNode nextCandidate = getNode(j);
                if (root.equals(nextCandidate))
                    root.addNext(j + 1);
            }
        }
    }

    public PetriNode addNoDupes(PetriNode pn) {
        int i = getNode(pn);
        if (i == -1) {
            v.addElement(pn);
            return pn;
        }
        PetriNode pn2 = getNode(i);
        return pn2;
    }

    /**
     return -1 if node not present, otherwise return
     location of node.
     */
    public int getNode(PetriNode pn) {
        for (int i = 0; i < v.size(); i++) {
            PetriNode pn2 = getNode(i);
            if (pn2.equals(pn)) return i;
        }
        return -1;
    }

    public void init() {
        buildPetriNet();
    }

    public PetriNode getNode(int i) {
        if (i < v.size())
            return (PetriNode) v.elementAt(i);
        return (PetriNode) v.elementAt(0);
    }

    public void print() {
        System.out.println(toString());
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < v.size(); i++)
            s = s + getNode(i).toString() + "\n";
        return s + "\n";
    }

    public int getSize() {
        return v.size();
    }
}