package sound;

/**
 * Created by
 * User: lyon
 * Date: Nov 29, 2003
 * Time: 11:11:38 AM
 *
 */

import gui.run.RunScroll;

import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Graphics;
import java.awt.Dimension;

public class DualTraceOscopePanelBusted
        extends JPanel {
    OscopePanel osp1 = new OscopePanel();
    OscopePanel osp2 = new OscopePanel();

    DualTraceOscopePanelBusted() {
        setLayout(new BorderLayout());
        add(getTopSbPanel(), BorderLayout.NORTH);
        add(getBottomSbPanel(), BorderLayout.SOUTH);
        add(getLeftSbPanel(), BorderLayout.WEST);
        add(getRightSbPanel(), BorderLayout.EAST);
        add(getTracePanel(), BorderLayout.CENTER);
    }

    private JPanel getTracePanel() {
        final JPanel tp1 = osp1.getTracePanel();
        final JPanel tp2 = osp2.getTracePanel();
        JPanel jp = new JPanel() {
            public void paint(Graphics g) {
                Dimension d = getSize();
                Dimension d2 = new Dimension(d.width, d.height/2);
                tp1.setSize(getSize());
                tp2.setSize(getSize());
                tp1.paint(g);
                tp2.paint(g);
                g.drawLine(0,0,200,200);
            }
        };
        jp.setLayout(new GridLayout(1,0));
        jp.add(tp1);
        jp.add(tp2);
        return jp;
    }

    public JPanel getRightSbPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 2));
        jp.add(osp2.getRightSb());
        jp.add(osp1.getRightSb());
        return jp;
    }

    public JPanel getLeftSbPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 2));
        jp.add(osp1.getLeftSb());
        jp.add(osp2.getLeftSb());
        return jp;
    }

    public JPanel getBottomSbPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(2, 0));
        jp.add(osp2.getBottomSb());
        jp.add(osp1.getBottomSb());
        return jp;
    }

    public JPanel getTopSbPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(1, 0));
        RunScroll topSb = osp1.getTopSb();
        jp.add(topSb);
        osp2.setTopSb(topSb);
        return jp;
    }

    public static void main(String args[]) {
        DualTraceOscopePanelBusted dtosp = new DualTraceOscopePanelBusted();
        gui.ClosableJFrame cf = new gui.ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(dtosp);
        c.setLayout(new GridLayout(1, 0));
        cf.setSize(400, 400);
        cf.show();
    }
}

