package sound;


public final class Audio {
    private double audioData[];
    private int sampleRate = 8000;
    private final static double twopi = Math.PI * 2;

    public Audio(double doubleArray[]) {
        audioData = doubleArray;
    }

    public Audio(UlawCodec ulc) {
        audioData = ulc.getDoubleArray();
    }

    public double[] getAudioData() {
        return audioData;
    }

    public int getSampleRate() {
        return sampleRate;
    }

    public int getLength() {
        return audioData.length;
    }

    public double getDuration() {
        return
                ((double) audioData.length /
                (double) sampleRate);
    }


    // A = transforms.fft(b);

    public double getMin() {
        double min = audioData[0];
        for (int i = 0; i < audioData.length; i++) {
            if (audioData[i] < min)
                min = audioData[i];
        }
        return min;
    }

    public double getMax() {
        double max = audioData[0];
        for (int i = 0; i < audioData.length; i++) {
            if (audioData[i] > max)
                max = audioData[i];
        }
        return max;
    }

    public void normalize() {
        double min = Math.abs(getMin());
        double max = Math.abs(getMax());
        double biggest;
        double amp;
        if (min > max)
            biggest = min;
        else
            biggest = max;
        amp = 0.98 / biggest;
        System.out.println(
                "Normalize:" +
                "The min is:" + min +
                "The max is:" + max);
        for (int i = 0; i < audioData.length; i++)
            audioData[i] =
                    audioData[i] * amp;
    }


}