package serialPorts;

/*
* Test.class is just that.. a Test
*/


import gnu.io.*;

import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import javax.comm.SerialPortEventListener;
import javax.comm.PortInUseException;
import javax.comm.CommPort;
import javax.comm.SerialPortEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

public class Test implements SerialPortEventListener {

    InputStream inputStream;
    OutputStream outputStream;
    SerialPort serialPort;
    Thread readThread;

    public static void main(String[] args) {
        String portName = "/dev/cu.modem";
        Test reader = new Test(portName);
    }

    public Test(String PortName) {
        CommPortIdentifier cpid = Utils.getPortByName(PortName);
       if (cpid == null){
            System.out.println("unable to obtain comm port;"+PortName);
            return;
        }
        serialPort  = (SerialPort) getPort(cpid);

        System.out.print("Get Streams\n");
        try {
            inputStream = serialPort.getInputStream();
            outputStream = serialPort.getOutputStream();
        } catch (IOException e) {
            e.printStackTrace();
        }
        try {
            serialPort.addEventListener((SerialPortEventListener) this);
        } catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        try {
            System.out.println("Baud is " + serialPort.getBaudRate());
            System.out.println("Bits is " + serialPort.getDataBits());
            System.out.println("Stop is " + serialPort.getStopBits());
            System.out.println("Par is " + serialPort.getParity());
            System.out.print("Set Params\n");
            serialPort.setSerialPortParams(19200, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
            System.out.println("Baud is " + serialPort.getBaudRate());
            System.out.println("Bits is " + serialPort.getDataBits());
            System.out.println("Stop is " + serialPort.getStopBits());
            System.out.println("Par is " + serialPort.getParity());
            System.out.print("Set Params\n");
            serialPort.setSerialPortParams(9600, SerialPort.DATABITS_7, SerialPort.STOPBITS_2, SerialPort.PARITY_ODD);
            System.out.println("Baud is " + serialPort.getBaudRate());
            System.out.println("Bits is " + serialPort.getDataBits());
            System.out.println("Stop is " + serialPort.getStopBits());
            System.out.println("Par is " + serialPort.getParity());
        } catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        System.out.print("Sending 0x01\n");
        try {
            outputStream.write((byte) 0x01);
            System.out.print("0x01 Sent\n");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private CommPort getPort(CommPortIdentifier cpid)  {
        try {
            return cpid.open("Test",200);
        } catch (PortInUseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case SerialPortEvent.BI:
                System.out.print("BI\n");
            case SerialPortEvent.OE:
                System.out.print("OE\n");
            case SerialPortEvent.FE:
                System.out.print("FE\n");
            case SerialPortEvent.PE:
                System.out.print("PE\n");
            case SerialPortEvent.CD:
                System.out.print("CD\n");
            case SerialPortEvent.CTS:
                System.out.print("CTS\n");
            case SerialPortEvent.DSR:
                System.out.print("DSR\n");
            case SerialPortEvent.RI:
                System.out.print("RI\n");
            case SerialPortEvent.OUTPUT_BUFFER_EMPTY:
                System.out.print("Out Buff Empty\n");
                break;
            case SerialPortEvent.DATA_AVAILABLE:
                System.out.print("Data Available\n");
                break;
        }
    }

}

