package serialPorts;

import java.util.StringTokenizer;


/**
 * Created by
 * User: lyon
 * Date: Dec 31, 2003
 * Time: 9:04:52 AM
 *
 */
public class SetPath {
    public static final int UNKNOWN = -1;
    public static final int MACOSX = 1;
    public static final int LINUX = 2;
    public static final int WINDOWS = 3;
    private static final String libName = "rxtxSerial";


    public static void main(String args[]) {
        loadNativeLib();
        System.out.println("done!");

    }
    public static String[] getLibPaths() {
        String lp = getLibPath();
        String propertySeparator = System.getProperty("path.separator");
        StringTokenizer st =
                new StringTokenizer(lp, propertySeparator);
        int n = st.countTokens();
        String s[] = new String[n];
        for (int i = 0; i < n; i++)
            s[i] = st.nextToken();
        return s;
    }

    public static void printNativeLibName() {
        String s = getNativeLibName(libName);
        System.out.println(s);
    }

    public static String getNativeLibName(String natLib) {
        String s = System.mapLibraryName(natLib);
        return s;
    }

    public static void printPreferredPath() {

        switch (getOs()) {
            case MACOSX:
                {
                    System.out.println("I suggest you put the native lib here:\n"
                    +"/Library/Java/Extensions/"+getNativeLibName(libName));
                    break;
                }
            case LINUX:
                {
                    //System.out.println("Linux not yet supported");
                    break;

                }
            case WINDOWS:
                {
                    //System.out.println("Windows not yet supported");
                    break;

                }
            case UNKNOWN:
                {
                    //System.out.println("Unknown OS:");
                    break;

                }
        }

    }

    private static String getLibPath() {
        return System.getProperty("java.library.path");
    }

    public static void printOs() {
        switch (getOs()) {
            case MACOSX:
                {
                    System.out.println("MACOSX detected");
                    break;
                }
            case LINUX:
                {
                    System.out.println("Linux detected");
                    break;

                }
            case WINDOWS:
                {
                    System.out.println("Windows detected");
                    break;

                }
            case UNKNOWN:
                {
                    System.out.println("Unknown OS");
                    break;

                }
        }

    }

    public static void printLibPath() {
        String path[] = getLibPaths();
        for (int i=0; i < path.length; i++)
            System.out.println(path[i]);
    }

    public static int getOs() {
        String os = System.getProperty("os.name");
        if (os.equals("Mac OS X"))
            return MACOSX;
        if (os.equals("Linux"))
            return LINUX;
        if (os.trim().startsWith("Windows"))
            return WINDOWS;
        return -1;
    }

    public static void loadNativeLib() {
        try {
            System.loadLibrary(libName);
        } catch (UnsatisfiedLinkError e) {
            reportNativeLibLoadFailed();

        }
    }

    private static void reportNativeLibLoadFailed() {
        String s = "could not load:" + libName
        +"\nOn your system, the file:\n"+getNativeLibName(libName)
        +" should be loaded into one of the \n"
        +"following directories:\n";

        System.out.println(s);
        printLibPath();
        printPreferredPath();
    }
}
