package security;

// security.WebStartUtils

import classUtils.reflection.Command;
import com.jcraft.jsch.UserInfo;
import futils.Futil;
import gui.In;
import net.ScpTo;
import net.rmi.utils.Compile;
import utils.SystemUtils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Date;
import java.util.jar.JarFile;


/**
 * DocJava, Inc. User: lyon Date: May 26, 2004 Time: 10:39:47 AM
 */
public class WebStartUtils {
    String passwordField1 = "";

    public static void upLoadEmbeddedClass() {
        Class classFromFile = Command.getClassFromFile();
        packSignUploadJNLP(classFromFile);
        In.message("finised with up load:");
        System.exit(0);
    }

    public static void generalUpload() {
        String className = In.getString("enter class name");
        Command.getClass(className);
        final File keyStoreFile =
                KeyUtils.getKeystoreFile();
        String vendor = In.getString("enter vendor");
        String url = In.getString("enter URL");
        final String password = In.getPassword("enter keystore password");
        KeyStore ks = KeyUtils.getKeyStore(password);
        final String alias = KeyUtils.getAlias(ks);
        String codeBase = In.getString("enter codebase, for example:" +
                "http://show.docjava.com:8086/" +
                "book/cgij/code/jnlp/");
        String iconUrl = In.getString("enter icon url, for example:" +
                "http://show.docjava.com:8086/" +
                "consulti/docjava.jpe");
        String user = In.getString("enter uid, for example:lyon");
        String host = In.getString("enter target upload host, " +
                "for example:" +
                "192.168.1.95");
        final String rootDirectory = In.getString("enter root directory on upload host," +
                " for example:/var/www/html/book/" +
                "cgij/code/jnlp/");
        String jarFileName = className +
                ".jar";
        Initium.packSignAndUpload(className,
                jarFileName,
                keyStoreFile,
                password,
                alias,
                vendor,
                url,
                codeBase,
                iconUrl,
                user,
                host,
                rootDirectory);
        In.message("finish upload");
        System.exit(0);
    }

    public static void packSignUploadJNLP() {
        packSignUploadJNLP(gui.In.getString("enter class name"));
    }

    public static void packSignUploadJNLP(Class c) {
        packSignUploadJNLP(c.getName());
    }

    public static void packSignUploadJNLP(String mainClassName) {

        Command.getClass(mainClassName);
        final File keyStoreFile =
                KeyUtils.getKeystoreFile();
        //= futils.Futil.getReadFile(
        //"select keystore");
        String vendor = "DocJava, Inc.";
        String url = "http://www.docjava.com";
        final String password = In.getPassword("enter keystore password");
        KeyStore ks = KeyUtils.getKeyStore(password);
        final String alias = KeyUtils.getAlias(ks);
        String codeBase = "http://show.docjava.com:8086/" +
                "book/cgij/code/jnlp/";
        String iconUrl = "http://show.docjava.com:8086/" +
                "consulti/docjava.jpe\"";
        String user = "lyon";
        String webServer = "192.168.1.95";
        final String rootDirectory = "/var/www/html/book/cgij/code/jnlp/";
        String jarFileName = mainClassName +
                ".jar";


        Initium.packSignAndUpload(mainClassName,
                jarFileName,
                keyStoreFile,
                password,
                alias,
                vendor,
                url,
                codeBase,
                iconUrl,
                user,
                webServer,
                rootDirectory);
    }

    public static void packSignOutputJnlp(final String mainClassName,
                                          final File keyStoreFile,
                                          final String password,
                                          final String alias,
                                          String vendor,
                                          String url) {
        String codeBase = "http://show.docjava.com:8086/book/cgij/code/jnlp/";
        String iconUrl = "http://show.docjava.com:8086/consulti/docjava.jpe\"";
        String user = "lyon";
        String webServer = "192.168.1.95";
        final String rootDirectory = "/var/www/html/book/cgij/code/jnlp/";
        String jarFileName = mainClassName +
                ".jar";
        Initium.packSignAndUpload(mainClassName,
                jarFileName,
                keyStoreFile,
                password,
                alias,
                vendor,
                url,
                codeBase,
                iconUrl,
                user,
                webServer,
                rootDirectory);

        //SignUtils.verify(jarFileName);
        verifyJar(jarFileName);
    }

    /**
     * Use the built-in JarVerifier class to verify the existance and
     * signing of the Jar file.
     */
    public static void verifyJar(String jarFileName) {
        try {
            new JarFile(jarFileName);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Synthesize and upload the JNLP and Jar files.
     *
     * @param title       Application title
     * @param vendor      Application owner
     * @param jarFileName A packed jar file
     * @param mainClass   A fully qualified class name
     * @param jnlpFile    The JNLP used for launching
     */
    public static void upLoadJnlp(String title,
                                  String vendor,
                                  String homePage,
                                  String jarFileName,
                                  String mainClass,
                                  File jnlpFile,
                                  String codeBase,
                                  String iconUrl,
                                  String user,
                                  String host,
                                  UserInfo ui,
                                  String rootDirectory) {
        String cmd =
                "<jnlp href=\"" +
                jnlpFile.getName() +
                "\" codebase=\"" +
                codeBase +
                "\">\n" +
                "  <information>\n" +
                "    <title>" +
                title +
                "</title>\n" +
                "    <vendor>" +
                vendor +
                "</vendor>\n" +
                "    <homepage href=\"" +
                homePage +
                "\"/>\n" +
                "<icon href=\"" +
                iconUrl +
                "/>" +
                "\n" +
                "    <offline-allowed />\n" +
                "  </information>\n" +
                "  \n" +
                "  <security>\n" +
                "    <all-permissions />\n" +
                "  </security>\n" +
                "  \n" +
                "  <resources>\n" +
                "    <j2se version=\"" +
                "1.4+" +
                "\" />\n" +
                "    <jar href=\"" +
                jarFileName +
                "\" />\n" +
                "  </resources>\n" +
                " \n" +
                "  <application-desc main-class=\"" +
                mainClass +
                "\" />\n" +
                "</jnlp>\n";
        try {
            uploadJnlp(jnlpFile,
                    cmd,
                    rootDirectory,
                    jarFileName,
                    user,
                    host,
                    ui);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void uploadJnlp(File jnlpFile,
                                   String cmd,
                                   final String rootDirectory,
                                   String jarFileName,
                                   String user,
                                   String host,
                                   UserInfo ui)
            throws IOException {
        saveToDisk(jnlpFile, cmd);
        String rJnlpFile = rootDirectory +
                jnlpFile.getName();
        String rJarFile = rootDirectory +
                jarFileName;
        ScpTo.scpTo(jnlpFile.toString(),
                user,
                host,
                rJnlpFile,
                ui);
        ScpTo.scpTo(jarFileName,
                user,
                host,
                rJarFile,
                ui);
        print("done with xfer at:" +
                new Date());
    }

    public static void print(Object o) {
        System.out.println(o);
    }

    public static void writeJnlp(String title,
                                 String vendor,
                                 String homePage,
                                 String jarFileName,
                                 String mainClass,
                                 File jnlpFile,
                                 String codeBase) {
        String jnlpData =
                "<jnlp href=\"" +
                jnlpFile.getName() +
                "\" codebase=\"file://" +
                codeBase +
                "\">\n" +
                "  <information>\n" +
                "    <title>" +
                title +
                "</title>\n" +
                "    <vendor>" +
                vendor +
                "</vendor>\n" +
                "    <homepage href=\"" +
                homePage +
                "\"/>\n" +
                "\n" +
                "    <offline-allowed />\n" +
                "  </information>\n" +
                "  \n" +
                "  <security>\n" +
                "    <all-permissions />\n" +
                "  </security>\n" +
                "  \n" +
                "  <resources>\n" +
                "    <j2se version=\"" +
                "1.4+" +
                "\" />\n" +
                "    <jar href=\"" +
                jarFileName +
                "\" />\n" +
                "  </resources>\n" +
                " \n" +
                "  <application-desc main-class=\"" +
                mainClass +
                "\" />\n" +
                "</jnlp>\n";
        try {
            saveToDisk(jnlpFile, jnlpData);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Save the <code>data</code> out to the file called
     * <code>jnlpFile</code>
     *
     * @param jnlpFile
     * @param data
     * @throws IOException
     */
    private static void saveToDisk(File jnlpFile,
                                   String data)
            throws IOException {
        System.out.println("output to:" +
                jnlpFile +
                "\n" +
                data);
        FileWriter fw =
                new FileWriter(jnlpFile);
        fw.write(data);
        fw.write("\n");
        fw.close();
    }

    public static void testGetWebstartLocation() {
        In.message("found javaws at:" + getWebstartLocation());
    }

    /**
     * Search for the Java web start application. If you cannot find it,
     * prompt the user. In the future, there should be a better way to do
     * this, but what, I don't know. And what if javaws cannot be found
     * because it is not installed? Tricky!
     *
     * @return the java webstart file.
     */
    public static File getWebstartLocation() {
        String s = SystemUtils.getDirectorySeparator();
        // check widows location:
        File f = new File("C:" +
                s +
                "Program Files" +
                s +
                "Java Web Start" +
                s +
                "javaws.exe");
        if (f.exists()) return f;
        // check mac location:
        f = new File("/" +
                "Applications" +
                s +
                "Utilities" +
                s +
                "Java" +
                s +
                "Java Web Start.app" +
                s +
                "Contents" +
                s +
                "MacOS" +
                s +
                "Java Web Start");
        if (f.exists()) return f;
        // check linux location for jdk1.5:
        f = new File("" +
                s +
                "usr" +
                s +
                "java" +
                s +
                "j2sdk1.5.0" +
                s +
                "bin" +
                s +
                "javaws");
        if (f.exists()) return f;
        f =
                Futil.getReadFile(
                        "could not find javaws, please help me locate it");
        if (f == null) {
            In.message("user canceled operation, program terminates");
            System.exit(0);
        }
        String cn = "security.WebstartUtils";
        System.out.println("please add:" + f + " to" + cn);
        return f;
    }

    /**
     * Start web start on the given url, then kill the process, to show we
     * have control over stopping and starting a process.
     */
    public static void startWebStart() {
        File webStart = getWebstartLocation();
        String args[] = {
            webStart.toString(),
            "http://show.docjava.com:8086/book/cgij/code/jnlp/dhry.Main.jnlp"
        };
        try {
            Runtime rt = Compile.asyncRunExec(args, null);
            rt.exit(0);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
