package security;

import gui.run.RunButton;
import gui.run.RunTextField;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;

/**
 * Copyright DocJava, inc.
 * User: lyon
 * Date: Sep 3, 2004
 * Time: 9:53:56 AM
 */

/**
 * The following is a typical example of the
 * kind of effort needed to develop an API.
 * Using the BeanDialog, we can greatly speed
 * dialog development.
 */
public class WebStartDialog extends JDialog {
    private WebStartBean wsb = null;

    public WebStartBean getWebStartBean() {
        return wsb;
    }

    public WebStartDialog(WebStartBean webStartBean) {
        wsb = webStartBean;
        Container c = getContentPane();
        c.setLayout(new BorderLayout());
        JPanel pa[] = getPanels();
        c.add(pa[0], BorderLayout.CENTER);
        c.add(pa[1], BorderLayout.LINE_END);
        c.add(getButtonPanel(this), BorderLayout.SOUTH);
        pack();
        setModal(true);
    }

    private JPanel[] getPanels() {
        JPanel tp = new JPanel(new GridLayout(0, 1));
        int l = 40;
        JPanel lp = new JPanel(new GridLayout(0, 1));
        JPanel pa[] = {lp, tp};
        lp.add(new JLabel("vendor"));
        tp.add(new RunTextField(wsb.getVendor(), l) {
            public void run() {
                wsb.setVendor(getText());
            }
        });
        lp.add(new JLabel("codeBase"));
        tp.add(new RunTextField(wsb.getCodeBase(), l) {
            public void run() {
                wsb.setCodeBase(getText());
            }
        });
        lp.add(new JLabel("iconUrl"));
        tp.add(new RunTextField(wsb.getIconUrl(), l) {
            public void run() {
                wsb.setIconUrl(getText());
            }
        });
        lp.add(new JLabel("hostUrl"));
        tp.add(new RunTextField(wsb.getHostUrl(), l) {
            public void run() {
                wsb.setHostUrl(getText());
            }
        });
        lp.add(new JLabel("rootDirectory"));
        tp.add(new RunTextField(wsb.getRootDirectory(), l) {
            public void run() {
                wsb.setRootDirectory(getText());
            }
        });
        lp.add(new JLabel("className"));
        tp.add(new RunTextField(wsb.getClassName(), l) {
            public void run() {
                wsb.setClassName(getText());
            }
        });
        lp.add(new JLabel("keyStoreFile"));
        tp.add(new RunTextField(wsb.getKeyStoreFile().toString(), l) {
            public void run() {
                wsb.setKeyStoreFile(getText());
            }
        });
        lp.add(new JLabel("JarFile"));
        tp.add(new RunTextField(wsb.getJarFileName().toString(), l) {
            public void run() {
                wsb.setJarFileName(getText());
            }
        });
        return pa;
    }

    public JPanel getButtonPanel(final JDialog parent) {
        JPanel jp = new JPanel(new FlowLayout());
        jp.add(new RunButton("OK") {
            public void run() {
                wsb.saveInPreferences();
                parent.setVisible(false);
            }
        });
        return jp;
    }

    public static void main(String[] args) {
        WebStartBean wsb = WebStartBean.getFromPreferences();
        wsb.setClassName("className");
        WebStartDialog wsd = new WebStartDialog(wsb);
        wsd.show();
        WebStartBean webStartBean = wsd.getWebStartBean();
        System.out.println("done wsd=" + webStartBean.toXml());
    }
}
