package security;

import classUtils.reflection.Command;
import gui.In;
import gui.dialogs.BeanDialog;
import xml.Utils;

import java.io.File;
import java.io.Serializable;
import java.security.KeyStore;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc.
 * User: lyon
 * Date: Sep 3, 2004
 * Time: 9:12:18 AM
 */
public class WebStartBean implements Serializable {
    private String password = "";
    private String vendor = "";
    private String codeBase = "";
    private String iconUrl = "";
    private String hostUrl = "";
    private String rootDirectory = "";
    private String className = "";
    private String keyStoreFile = "";
    private String jarFileName = "";
    private String alias = "";
    private String webServer = "";
    private String webServerUid = "";

    public WebStartBean() {
    }



    public static WebStartBean fromXml(String xmlString) {
        return (WebStartBean) Utils.decodeXml(xmlString);
    }

    public String toXml() {
        return Utils.toXml(this)+"</java>";
    }

    public String toString() {
        return "\npassword=" + password +
                "\nvendor=" + vendor +
                "\ncodeBase=" + codeBase +
                "\niconUrl=" + iconUrl +
                "\nhostUrl=" + hostUrl +
                "\nrootDirectory=" + rootDirectory +
                "\nclassName=" + className +
                "\nkeyStoreFile=" + keyStoreFile +
                "\njarFileName=" + jarFileName +
                "\nalias=" + alias +
                "\nwebServer=" + webServer +
                "\nwebServerUid=" + webServerUid;
    }

    public String getVendor() {
        return vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getCodeBase() {
        return codeBase;
    }

    public void setCodeBase(String codeBase) {
        this.codeBase = codeBase;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getHostUrl() {
        return hostUrl;
    }

    public void setHostUrl(String hostUrl) {
        this.hostUrl = hostUrl;
    }

    public String getRootDirectory() {
        return rootDirectory;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getJarFileName() {
        return jarFileName;
    }

    public void setJarFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getWebServer() {
        return webServer;
    }

    public void setWebServer(String webServer) {
        this.webServer = webServer;
    }

    public String getWebServerUid() {
        return webServerUid;
    }

    public void setWebServerUid(String webServerUid) {
        this.webServerUid = webServerUid;
    }

    public String getKeyStoreFile() {
        return keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    private final static String key = "WebStartBean";

    public void saveInPreferences() {
        String s = toXml();
        Preferences p = Preferences.userRoot();
        p.put(key, s);
    }

    public static WebStartBean getFromPreferences() {
        Preferences p = Preferences.userRoot();
        String s = p.get(key, null);
        if (s==null) return WebStartBean.getDefaultWebStartBean();
        return fromXml(s);
    }

    public static void main(String[] args) {
        //testWebStartBean();
        WebStartBean w2 = WebStartBean.getFromPreferences();
        System.out.println("read from preferences"+w2.toXml());
    }

    private static void testWebStartBean() {
        WebStartBean wsb = new WebStartBean();
        wsb.setAlias("docjava");
        wsb.setClassName("security.WebStartBean");
        wsb.setVendor("DocJava, Inc");
        final String x = wsb.toXml();
        System.out.println(x);
        wsb.saveInPreferences();
    }

    /**
     * Get WebStartBean and use a GUI
     * to prompt the USER.
     *
     * @return
     */
    public static WebStartBean getDefaultWebStartBeanGUI() {
        BeanDialog dialog = new BeanDialog(WebStartBean.getFromPreferences());
        dialog.pack();
        dialog.show();
        Object o = dialog.getData();
        return (WebStartBean) o;
    }

    public static WebStartBean getDefaultWebStartBean() {
        WebStartBean wsb = new WebStartBean();
        String password = In.getPassword("enter keystore password");
        wsb.setPassword(password);
        KeyStore ks = KeyUtils.getKeyStore(password);
        File ksf = KeyUtils.getKeystoreFile();
        wsb.setKeyStoreFile(ksf.toString());
        ks = KeyUtils.getKeyStore(ksf, password);
        wsb.setClassName(Command.getClassFromFile().getName());
        wsb.setRootDirectory("/var/www/html/book/cgij/code/jnlp/");
        wsb.setWebServer("192.168.1.95");
        wsb.setWebServerUid("lyon");
        wsb.setIconUrl("http://show.docjava.com:8086/" +
                "consulti/docjava.jpe\"");
        wsb.setCodeBase("http://show.docjava.com:8086/" +
                "book/cgij/code/jnlp/");
        wsb.setAlias(KeyUtils.getAlias(ks));
        wsb.setVendor("DocJava, Inc.");
        wsb.setJarFileName(wsb.getClassName() + ".jar");
        wsb.setHostUrl("http://www.docjava.com");
        return wsb;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
