package security;

import gui.In;
import sun.security.pkcs.PKCS10;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;

import java.io.*;
import java.security.*;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.text.MessageFormat;
import java.util.*;

import gui.In;

/**
 * DocJava, Inc. User: lyon Date: May 20, 2004
 * Time: 6:35:50 AM
 */
public class KeyUtils {
    public static final ResourceBundle rb = ResourceBundle.getBundle(
            "sun.security.util.Resources");

    public static void main(String[] args) {
        //testX500Name();
        //testGenerateKeyPair();
        runImportCertificate();
    }

    /**
     * a gui for importing certificates
     */
    public static void runImportCertificate() {
        try {
            importCertificate();
        } catch (Exception e) {
            In.message(e);
        }
    }

    private static void testX500Name() {
        X500Name x500Name = null;
        try {
            x500Name = getX500Name();
        } catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(x500Name);
    }

    /**
     * Open the <code>.keystore</code> file.
     * Prompt the user for an alias.
     * Open the new certificate from the CA.
     * Modify the <code>.keystore</code> file with
     * the new certificate.
     * If files are missing, recover from the
     * error with grace.
     * @throws FileNotFoundException
     * @throws KeyStoreException
     * @throws CertificateException
     * @throws IOException
     */
    public static void importCertificate()
            throws FileNotFoundException,
                   KeyStoreException,
                   CertificateException,
                   IOException {
        final File ksf = getKeystoreFile();
        final String password = getPassword();
        KeyStore ks = getKeyStore(ksf, password);
        final String alias = getAlias(ks);
        X509Certificate cert = (X509Certificate) getCertificate(
                getCertificateFile());
        if (ks.containsAlias(alias))
            ks.deleteEntry(alias);
        verifyCert(cert);
        ks.setCertificateEntry(alias, cert);
        save(ksf, ks, password);
        In.message("import complete!");
    }
   /**
    * @param cert
    * @return true if the subjectDN and issuer are the same.
    */
    public static boolean isSelfSigned(
            X509Certificate cert) {
        return cert.getSubjectDN().equals(
                cert.getIssuerDN());
    }

    /**
     * Display exception if certificate
     * cannot be verified. Kill program.
     * @param cert
     */
    public static void verifyCert(
            X509Certificate cert) {
        try {
            if (isSelfSigned(cert))
                cert.verify(cert.getPublicKey());
        } catch (Exception e) {
            In.message(e);
            System.exit(0);
        }
    }
    /**
     * Use a certificate file to to
     * make a certificate instances.
     * @param certF
     * @return
     * @throws CertificateException
     * @throws FileNotFoundException
     * @throws IOException
     */
    public static Certificate getCertificate(
            File certF)
            throws CertificateException,
                   FileNotFoundException,
                   IOException {
        CertificateFactory cf =
                CertificateFactory.getInstance(
                        "X509");
        Collection col = importCertificates(cf,
                                            certF);
        Iterator i = col.iterator();
        X509Certificate c = null;
        while (i.hasNext()) {
            Certificate cert = (Certificate) i.next();
            if (cert instanceof X509Certificate)
                c = (X509Certificate) cert;
            //System.out.println(cert);
        }
        return c;
    }
    /**
     * get a collection of certificates from
     * a certificateFactory.
     * @param cf
     * @param certF
     * @return
     * @throws CertificateException
     * @throws FileNotFoundException
     * @throws IOException
     */
    private static Collection importCertificates(
            CertificateFactory cf, File certF)
            throws CertificateException,
                   FileNotFoundException,
                   IOException {
        final FileInputStream fis = new FileInputStream(
                certF);
        Collection col = null;
        try {
            col = cf.generateCertificates(fis);
        } catch (CertificateException e) {
            boolean b = gui.In.getBoolean(
                    "Cert exception, would you like me to try to translate it?");
            if (!b) return importCertificates(cf);
            CertUtils.cleanThawtes();
            return importCertificates(cf);
        }
        return col;
    }

    private static Collection importCertificates(
            CertificateFactory cf)
            throws CertificateException,
                   IOException {
        return importCertificates(cf,
                                  futils.Futil.getReadFile(
                                          "select pcks7 cert"));
    }

    /**
     * Prompt the user for a PKCS7 format
     * certificate.
     * @return a <code>File</code> instance that is unchecked.
     * That is, the file may not even exist.
     */
    private static File getCertificateFile() {
        return
                futils.Futil.getReadFile(
                        "select a cert in pkcs7 format");
    }
    /**
     * List the security providers in their order of
     * preference.
     */
    public static void printProviders() {
        System.out.println("provider list:");
        Provider p[] = Security.getProviders();
        for (int i = 0; i < p.length; i++)
            printProvider(p[i]);
    }

    private static void printProvider(
            final Provider provider) {
        System.out.println(
                "Name:" + provider.getName());
        System.out.println(
                "Provider:" + provider);
        System.out.println(
                "Info:" + provider.getInfo());
        System.out.println("algorithm:" +
                           provider.getProperty(
                                   "algorithm"));
        System.out.println("-----");
    }
    /**
     * print out a nicely formatted version of
     * a given key.
     * @param key
     */
    public static void printKey(Key key) {
        if (key instanceof DSAKey) {
            System.out.println("key is DSA");
            System.out.println("P value is " +
                               ((DSAKey) key).getParams()
                               .getP());
        } else {
            System.out.println("key is NOT DSA");
            System.out.println(key);
        }
    }

    /**
     * get a certificate based on a GUI prompt
     * to the user for a password and an alias.
     * @return   Certificate
     */
    public static Certificate getCertificate() {
        String password = getPassword();
        String alias = getAlias();
        return
                getCertificate(alias,
                               password);
    }
    /**
     * Prompt the user for a password.
     * Do not echo it on the screen
     * @return a string containing the password.
     */
    public static String getPassword() {
        String password = gui.In.getPassword(
                "please enter keystore password");
        return password;
    }

    private static String getAlias() {
        String alias = gui.In.getString(
                "please enter certificate alias");
        return alias;
    }
    /**
     * Given an alias and password, open the
     * default keystore and return the certificate.
     * @param alias
     * @param password
     * @return a Certificate instance.
     */
    public static Certificate getCertificate(
            String alias, String password) {
        try {
            // Load the keystore in the user's home directory
            KeyStore keystore = getKeystore(
                    password);

            // Get certificate

            return keystore.getCertificate(alias);
        } catch (KeyStoreException e) {
            e.printStackTrace();
        } catch (CertificateException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (java.io.IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * Return a <code>KeyStore</code> assuming
     * that one already exists.
     * If the <code>.keystore</code> file does not
     * exist, then offer to create one or
     * look for one.
     *
     * @param password to the keystore
     * @return KeyStore instance
     */
    public static KeyStore getKeystore(
            String password)
            throws KeyStoreException,
                   IOException,
                   NoSuchAlgorithmException,
                   CertificateException {
        File f = getKeystoreFile();
        FileInputStream is = new FileInputStream(
                f);
        KeyStore keystore = KeyStore.getInstance(
                KeyStore.getDefaultType());
        keystore.load(is,
                      password.toCharArray());
        return keystore;
    }

    public static void testGenerateKeyPair() {
        System.out.println("generateKeyPair:" +
                           generateKeyPair());
    }

    /**
     * Creates a keystore, then generates a
     * keypair for it.
     *
     * @return KeyStore with keypair in it.
     */
    public static KeyStore generateKeyPair() {
        KeyStore ks = null;
        try {
            ks = generateKeyStore();
            generateKeyPair(ks);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ks;
    }

    /**
     * Generate a keystore without reading it from
     * a file. Excellent for when no keystore is
     * found.
     *
     * @return a default type keystore instance
     */
    public static KeyStore generateKeyStore()
            throws KeyStoreException,
                   IOException,
                   NoSuchAlgorithmException,
                   CertificateException {
        KeyStore ks =
                KeyStore.getInstance(
                        KeyStore.getDefaultType());
        ks.load(null, null);
        return ks;
    }

    /**
     * Prompts the user for X.509 certificate
     * information. Generates a private and public
     * keypair, then add it to the keystore. Uses
     * RSA algorithm with a 1024 bit key size.
     */
    public static void generateKeyPair(
            KeyStore ks)
            throws Exception {
        X500Name x500Name = getX500Name();
        int validity = 90;
        int keysize = 1024;
        String alias = In.getString(
                "enter alias");
        String keyPass = In.getPassword(
                "enter password");
        String sigAlgName = "MD5WithRSA";
        String keyAlgName = "RSA";
        CertAndKeyGen keypair = new CertAndKeyGen(
                keyAlgName, sigAlgName);
        keypair.generate(keysize);
        PrivateKey privKey = keypair.getPrivateKey();
        X509Certificate chain[] = new X509Certificate[1];
        chain[0] =
        keypair.getSelfCertificate(x500Name,
                                   validity * 24 *
                                   60 *
                                   60);
        ks.setKeyEntry(alias,
                       privKey,
                       keyPass.toCharArray(),
                       chain);
    }

    /**
     * get a public and private key, given that a
     * KeyStore exists and a certificate exists
     * that corresponds to the the given <code>
     * alias</code>.
     */
    public static KeyPair getKeyPair(
            KeyStore keystore,
            String alias,
            String password) {
        try {
            // Get private key
            Key key = keystore.getKey(alias,
                                      password.toCharArray());
            if (key instanceof PrivateKey) {
                // Get certificate of public key
                java.security.cert.Certificate cert = keystore.getCertificate(
                        alias);

                // Get public key
                PublicKey publicKey = cert.getPublicKey();

                // Return a key pair
                return new KeyPair(publicKey,
                                   (PrivateKey) key);
            }
        } catch (UnrecoverableKeyException e) {
        } catch (NoSuchAlgorithmException e) {
        } catch (KeyStoreException e) {
        }
        return null;
    }

    public static KeyStore getKeyStore() {
        return getKeyStore(getPassword());
    }

    /**
     * Selects the <code>.keystore</code> file in
     * the users home directory.
     *
     * @return KeyStore
     */
    public static KeyStore getKeyStore(
            String password) {
        File ksf = getKeystoreFile();
        if (ksf.exists())
            return getKeyStore(ksf, password);
        In.getBoolean(
                "I could not find the .keystore file...sorry");
        return null;
    }

    public static KeyStore getKeyStore(
            File keyStoreFile, String password) {
        KeyStore keystore = null;
        try {
            FileInputStream is = new FileInputStream(
                    keyStoreFile);
            keystore =
            KeyStore.getInstance(
                    KeyStore.getDefaultType());
            keystore.load(is,
                          password.toCharArray());
            is.close();
        } catch (Exception e) {
            In.message(e);
        }
        return keystore;
    }
    /**
     * Given a key store, list all the alias
     * elements there. Certificates are located
     * via the alias.
     * @param keystore
     * @return An array of alias members.
     */
    public static String[] getAliasArray(
            KeyStore keystore) {
        Enumeration enum = null;
        try {
            // List the aliases
            enum = keystore.aliases();
        } catch (KeyStoreException e) {
            e.printStackTrace();
        }
        Vector v = new Vector();
        for (; enum.hasMoreElements();) {
            String alias = (String) enum.nextElement();
            v.addElement(alias);
        }
        String s[] = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    /**
     * Write our key store instance out to the
     * given file. A GUI prints out exceptions,
     * should they be thrown.
     *
     * @param ksFile   a file to be created or
     *                 overwritten.
     * @param ks       the key store to be saved.
     * @param password verifies the file.
     */
    public static void save(File ksFile,
                            KeyStore ks,
                            String password) {
        try {
            FileOutputStream fos = new FileOutputStream(
                    ksFile.getAbsolutePath());
            ks.store(fos,
                     password.toCharArray());
            fos.close();
        } catch (Exception e) {
            In.message(e);
        }
    }

    /**
     * Look for the <code>.keystore</code>
     * file in the home directory. If it is
     * not there, offer to look for it.
     * If the user does not have it, offer to
     * create one. If you have to create a keystore,
     * offer to create a certificate request, as well.
     *
     * @return the keystore file
     */
    public static File getKeystoreFile() {
        File file = getDefaultKeyStoreFile();
        if (file.exists()) return file;
        final String prompt = "file:" + file +
                              " does not exist:";
        boolean b = In.getBoolean(
                prompt +
                "do you have a keystore?");
        if (b)
            return futils.Futil.getReadFile(
                    prompt);
        b =
        In.getBoolean(
                "would you like me to generate a keystore for you?");
        if (b) return makeKeyStoreFile();
        In.message(
                "program exits try:keytool -genkey -keyalg RSA -alias docjava");
        System.exit(0);
        return null;
    }
     /**
      * Ouput a file based on user prompts,
      * that contains the text for a Certificate
      * Request. This is used with a CA to obtain
      * a signed certificate.
      * @param alias
      * @param keyPass
      * @param ks
      */
    public static void writeCertReq(String alias,
                                    String keyPass,
                                    KeyStore ks) {
        Object objs[] = recoverPrivateKey(ks,
                                          alias,
                                          keyPass.toCharArray());
        PrivateKey privKey = (PrivateKey) objs[0];
        if (keyPass == null)
            keyPass =
            new String((char[]) objs[1]);
        PKCS10 request = null;
        try {
            Certificate cert = ks.getCertificate(
                    alias);
            request = new PKCS10(
                    cert.getPublicKey());
            String sigAlgName = "MD5WithRSA";
            Signature signature = Signature.getInstance(
                    sigAlgName);
            signature.initSign(privKey);
            X500Name subject = new X500Name(
                    ((X509Certificate) cert).getSubjectDN()
                    .toString());
            X500Signer signer = new X500Signer(
                    signature, subject);
            request.encodeAndSign(signer);
            request.print(System.out);
            boolean b = In.getBoolean(
                    "would you like to save the certificate request to a file?");
            if (!b) return;
            File f = futils.Futil.getWriteFile(
                    "select file.cert");
            FileOutputStream fos = new FileOutputStream(
                    f);
            PrintStream ps = new PrintStream(fos);
            request.print(ps);
            fos.close();
        } catch (Exception e) {
            In.message(e);
        }
    }

    private static Object[] recoverPrivateKey(
            KeyStore ks,
            String alias,
            char keyPass[]) {
        Key key = null;
        try {
            key = ks.getKey(alias, keyPass);
        } catch (Exception e) {
            In.message(e);
        }
        return (new Object[]{
            (PrivateKey) key, keyPass
        });
    }

    /**
     * Creates the default .keystore file,
     * assuming that it does not already exist.
     * Prompts the user to create a key pair.
     */
    public static File makeKeyStoreFile() {
        File f = getDefaultKeyStoreFile();
        if (f.exists()) {
            In.message(
                    "file:" + f +
                    " exists, program terminates");
            System.exit(0);
        }
        try {
            KeyStore ks = KeyUtils.generateKeyStore();
            generateKeyPair(ks);
            String pswd = In.getPassword(
                    "enter keystore password");
            KeyUtils.save(f, ks, pswd);
            In.message("file:" + f + " created");
            promptForCertReq(ks, pswd);
        } catch (Exception e) {
            In.message(e);
        }
        return f;
    }

    private static void promptForCertReq(
            KeyStore ks, String pswd) {
        boolean b = In.getBoolean(
                "would you like me to generate a certificate request?");
        if (!b) return;
        writeCertReq(getAlias(ks), pswd, ks);
    }

    /**
     * Check to make sure this file exists.
     *
     * @return .keystore file in users home.
     */
    public static File getDefaultKeyStoreFile() {
        return new File(System.getProperty(
                "user.home") +
                        File.separatorChar +
                        ".keystore");
    }


    private static void testGetAlias() {
        String password = gui.In.getString(
                "please enter keystore password");
        KeyStore keystore = getKeyStore(password);
        String s[] = getAliasArray(keystore);
        for (int i = 0; i < s.length; i++)
            System.out.println("alias:" + s[i]);
    }

    private static void print(Certificate c) {
        System.out.println("-----" +
                           "\n" +
                           c.getClass().toString() +
                           "\n" + c);
    }

    private static void print(Certificate[] c) {
        for (int i = 0; i < c.length; i++)
            print(c[i]);
    }

    /**
     * Given a keystore instance, provide
     * a multiple choice GUI that enables the
     * user to select a certificate alias.
     * @param keyStore
     * @return A string version of the certificate alias
     */
    public static String getAlias(KeyStore keyStore) {
        String a[] = getAliasArray(keyStore);
        return In.multiPrompt(a,
                              "select an alias",
                              "alias dialog")
                .toString();
    }
    /**
     * Given an X509 Certificate,
     * print out all the relevant detail.
     * @param cert
     * @param out
     * @throws Exception
     */
    public static void printX509Cert(
            X509Certificate cert,
            PrintStream out)
            throws Exception {
        MessageFormat form = new MessageFormat(
                rb.getString(
                        "*PATTERN* printX509Cert"));
        Object source[] = {
            cert.getSubjectDN().toString(), cert.getIssuerDN()
                .toString(), cert.getSerialNumber()
                .toString(16), cert.getNotBefore()
                .toString(), cert.getNotAfter()
                .toString(), getCertFingerPrint(
                        "MD5", cert), getCertFingerPrint(
                                "SHA1", cert)
        };
        out.println(
                form.format(((Object) (source))));
    }

    private static void byte2hex(byte b,
                                StringBuffer buf) {
        char hexChars[] = {
            '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
            'A', 'B', 'C', 'D', 'E', 'F'
        };
        int high = (b & 0xf0) >> 4;
        int low = b & 0xf;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private static String toHexString(
            byte block[]) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; i++) {
            byte2hex(block[i], buf);
            if (i < len - 1)
                buf.append(":");
        }
        return buf.toString();
    }

    private static String getCertFingerPrint(
            String mdAlg, Certificate cert)
            throws Exception {
        byte encCertInfo[] = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance(
                mdAlg);
        byte digest[] = md.digest(encCertInfo);
        return toHexString(digest);
    }
    /**
     * Prompt the user for all the details
     * needed to generate a self-signed
     * x500 certificate. This is
     * stored in a datastructure called
     * the <code>X500Name</code>
     * @return
     * @throws IOException
     */
    public static X500Name getX500Name()
            throws IOException {
        boolean promptP = false;
        String commonName = "Unknown";
        String organizationalUnit = "Unknown";
        String organization = "Unknown";
        String city = "Unknown";
        String state = "Unknown";
        String country = "Unknown";
        X500Name name;
        do {
            commonName =
            In.getString(
                    "What is your first and last name?");
            organizationalUnit =
            In.getString("What is the name of your" +
                         " organizational unit?");
            organization =
            In.getString("What is the name " +
                         "of your organization?");
            city =
            In.getString(
                    "What is the name " +
                    "of your City or Locality?");
            state =
            In.getString(
                    "What is the name of " +
                    "your State or Province?");
            country =
            In.getString(
                    "What is the two-letter " +
                    "country code for this unit?");
            name =
            new X500Name(commonName,
                         organizationalUnit,
                         organization,
                         city,
                         state,
                         country);
            promptP =
            In.getBoolean(
                    "Is " + name + " correct?");
        } while (!promptP);
        return name;
    }
}
