package security;

import classUtils.pack.DependencyUtils;
import com.jcraft.jsch.UserInfo;
import gui.In;
import net.ScpTo;
import utils.SystemUtils;

import java.io.File;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 4, 2004
 * <p/>
 * Time: 6:40:02 PM
 */
public class Initium {
    public static void main(String[] args) {
        //upLoadEmbeddedClass();
        packSignAndUpload();
        //WebStartUtils.testGetWebstartLocation();  <- this works!
    }

    /**
     * All defaults now in a <code>WebStartBean</code> with a confirming
     * dialog. However, the defaults never change.
     */
    public static void packSignAndUpload() {
        WebStartBean wsb = WebStartBean.getDefaultWebStartBeanGUI();
        packSignAndUpload(wsb);
        if (In.getBoolean("Done! Go again?"))
            packSignAndUpload();
        System.exit(0);
    }

    public static void packSignAndUpload(WebStartBean wsb) {
        packSignAndUpload(wsb.getClassName(),
                wsb.getJarFileName(),
                new File(wsb.getKeyStoreFile()),
                wsb.getPassword(),
                wsb.getAlias(),
                wsb.getVendor(),
                wsb.getHostUrl(),
                wsb.getCodeBase(),
                wsb.getIconUrl(),
                wsb.getWebServerUid(),
                wsb.getWebServer(),
                wsb.getRootDirectory());
    }

    public static void packSignAndUpload(final String mainClassName,
                                          String jarFileName,
                                          final File keyStoreFile,
                                          final String password,
                                          final String alias,
                                          String vendor,
                                          String url,
                                          String codeBase,
                                          String iconUrl,
                                          String user,
                                          String webServer,
                                          final String rootDirectory) {
        DependencyUtils.pack(mainClassName,
                jarFileName);
        SignUtils.sign(keyStoreFile + "",
                password,
                jarFileName,
                alias);
        String title = mainClassName;
        String localCodeBase = keyStoreFile.getParent();
        String separator = SystemUtils.getDirectorySeparator();
        final File localJnlpFile = new File(localCodeBase +
                separator +
                mainClassName +
                ".local" +
                ".jnlp");
        final File jnlpFile = new File(localCodeBase +
                separator +
                mainClassName +
                ".jnlp");
        WebStartUtils.writeJnlp(title,
                vendor,
                url,
                jarFileName,
                mainClassName,
                localJnlpFile,
                localCodeBase);
        UserInfo ui = new ScpTo.MyUserInfo();
        WebStartUtils.upLoadJnlp(title,
                vendor,
                url,
                jarFileName,
                mainClassName,
                jnlpFile,
                codeBase,
                iconUrl,
                user,
                webServer,
                ui,
                rootDirectory);
    }
}
