package net.web;

import net.mail.Smtp;
import net.proxy.Proxy;
import net.stocks.Quote;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Vector;

/**
 * For homework, add 6 search engines to the meta search
 * facility so that a search string with multiple elements
 * is used to create a single result that can be contantated
 * into one massive search using all 6 the search engines.
 * You may select your own search engines.
 * For example
 * MetaSearch ms =  new MetaSearch(
 * "java server pages");
 * System.out.println(ms.getSearchResults());
 */
public class MetaSearch
        implements Runnable {
    String ss;
    String email;
    //
    //request.getParameter ("searchString"));

    Thread thread = new Thread(this);
    Vector sv = new Vector();

    //For google, use:
    //http://www.google.com/search?hl=en&lr=&ie=UTF-8&q=searchItem1+SearchItem2
    //For homework
    // extend the search engine so that it uses
    // http://search.excite.com/
    // http://search.yahoo.com/search?ei=UTF-8&fr=sfp&p=java+cobal
    // http://sjc-search.sjc.lycos.com/default.asp?lpv=1&loc=lycoshp&tab=web&query=java+cobal
    private void initSearchVector() {
        //sv.addElement("http://www.google.com/search?q="
        //        + ss);
        sv.addElement("http://search.yahoo.com/search?ei=UTF-8&fr=sfp&p=" + ss);
        sv.addElement("http://citeseer.ist.psu.edu/cis?q=" + ss + "&submit=Search+Documents&cs=1");
        //sv.addElement("http://www.google.com/search?hl=en&lr=&ie=UTF-8&q=java+cobol");
    }

    public MetaSearch(String searchString) {
        // for jdk1.4.x, uncomment the try,catch
        try {
            // used to be that the encoding
            // was not passed as an argument.
            // however, this was deprecated.
            ss = URLEncoder.encode(searchString, "UTF-8");
            System.out.println("searchString=" + ss);
            // ss = URLEncoder.encode(searchString);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        initSearchVector();
    }

    public MetaSearch(String searchString, String _email) {
        // for jdk1.4.x, uncomment the try,catch
        try {
            // used to be that the encoding
            // was not passed as an argument.
            // however, this was deprecated.
            ss = URLEncoder.encode(searchString, "UTF-8");
            // ss = URLEncoder.encode(searchString);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        email = _email;
        initSearchVector();
        thread.start();
    }

    public void run() {
        String message = getSearchResults();
        Smtp sm = new Smtp();
        sm.setMailServerHostName("192.168.1.95");
        sm.setRecipientEmail(email);
        sm.setSenderEmail("lyon@docjava.com");
        sm.setMessage(message);
        sm.start();
    }

    public String getSearchResults() {
        // this may not be needed when you get home.

        Proxy.setSoeProxy();
        String searchResults =
                "Search for " + ss + " yields:<hr><p>";
        for (int i = 0; i < sv.size(); i++) {
            String url = (String) sv.elementAt(i);
            System.out.println("url=" + url);
            String s = "<hr><p>" + url
                    + " yields:<p>"
                    + //net.web.Browser.toString(url);
                    Quote.getUrl(url);
            searchResults =
                    searchResults + s;
        }
        return searchResults;
    }

    public static void main(String args[]) {
        MetaSearch ms = new MetaSearch("java server pages");
        String searchResults = ms.getSearchResults();
        System.out.println(searchResults);
        System.out.println("done!");
    }
}