package net.server.servlets;

import java.util.*;


/**
 *  FormCSQL  Class
 */

public class FormCSQL {

    private SQLBeanie dbw = new SQLBeanie();

    FormCDataParser fc;


    /**
     * FormCSQL   Constructor
     */

    public FormCSQL(FormCDataParser _fc) {
        fc = _fc;
    }


    /**
     * Creates a FormC.sql outfile with the sequel insert statements

     */

    public void generateFormCSQL(String[] fieldNames, String[] fieldValues) {

        int courseKeyIndex = fc.getCourseKeyIndex();
        String students[] =
                fc.getCourseStudentsIdByKey(courseKeyIndex);

        String studentsData[][] = getData(students, fieldNames, fieldValues);

        createFormCSql(getFormCSqlRows(courseKeyIndex, studentsData));

    }


    /**
     * getData    Method
     *

     * @return    String[][]
     */

    private String[][] getData(String students[], String fields[],
                               String fValues[]) {

        int noOfRows = students.length;
        int noOfColumns = 9;	// student id + 8 codes

        String data[][] = new String[noOfRows][noOfColumns];

        for (int i = 0; i < data.length; i++) {
            for (int j = 0; j < data[i].length; j++) {
                switch (j) {
                    case 0:
                        data[i][j] = students[i];
                        break;

                    default:
                        for (int k = 0; k < fields.length; k++) {
                            if (fields[k].equals("cbo" + (i) + (j - 1))) {
                                data[i][j] = fValues[k];
                                break;
                            }
                        }
                        break;
                }
            }

        }

        return data;
    }


    /**
     * getFormCSqlRows        Method
     *
     * @return    			String[]
     */

    private String[] getFormCSqlRows(int index, String[][] studentsData) {

        Vector sqlRows = new Vector();

        for (int i = 0; i < studentsData.length; i++) {
            getFormCSqlRow(sqlRows, getFormCRow(index, studentsData[i]));
        }

        return (vectorToString(sqlRows));
    }


    /**
     * getFormCSqlRow         Method
     *

     */

    private void getFormCSqlRow(Vector vSql, Vector vData) {


        for (Enumeration e = vData.elements(); e.hasMoreElements();) {
            String strObj[] = (String[]) e.nextElement();


            String sql = "Insert into all_forms values (";


//deh to Umy this is messy !!!
/*
			for (int i = 0; i < strObj.length; i++) {
				if (i == 0) {
					sql = sql + strObj[i] + ",";
				}
				else if(i < (strObj.length - 1)) {
					sql = sql + Html.quote(strObj[i]) + ",";
				}
				else {
					sql = sql + strObj[i] + ")";
					vSql.add(sql);
				}
			}
		}
*/
//deh's way
            int i;  //Want this variable to last a little longer than the for loop

            for (i = 0; i < strObj.length - 1; i++)
                sql = sql + Html.singleQuote(strObj[i]) + ",";

// Last item doesn't need a comma but a parenthesis	and a semi-colon
            sql = sql + Html.singleQuote(strObj[i]) + ");";
            vSql.add(sql);
//deh
//			System.out.println(sql);
//deh
        }
    }


    /**
     * getFormCRow            Method
     *
     * @return    			Vector
     */

    private Vector getFormCRow(int index, String[] data) {

        String formCId = "1";

        Vector rows = new Vector();

        for (int i = 0; i < data.length; i++) {

            List formcRow = new ArrayList();
            formcRow.add(data[0]);
            formcRow.add(fc.getCourseNoByKey(index));
            formcRow.add(fc.getCourseSectionByKey(index));
            formcRow.add(fc.getCourseTermByKey(index));
            formcRow.add(fc.getCourseYearByKey(index));
            formcRow.add(formCId);

            switch (i) {
                case 0:
                    break;
                default:
                    formcRow.add("" + i);
                    formcRow.add(data[i]);
                    rows.add(objectToString(formcRow));
            }
        }

        return rows;
    }


    /**
     * Returns an array of String Object
     *
     * @return    			String[]
     */

    public String[] objectToString(List l) {
        String str[] = new String[l.size()];

        Iterator it = l.iterator();

        for (int i = 0; it.hasNext(); i++) {
            str[i] = (String) it.next();
        }

        return str;
    }

    /**
     * Returns an array of String Object
     *
     * @return    			String[]
     */

    public String[] vectorToString(Vector v) {

        String str[] = new String[v.size()];
        int i = 0;

        for (Enumeration e = v.elements(); e.hasMoreElements(); i++) {
            str[i] = (String) e.nextElement();
        }

        return str;
    }

    /**
     * createFormCSql	        Method
     *
     */

    private void createFormCSql(String[] sqlRows) {


        dbw.open();

//		try {

// This code is only for writing SQL to a file

//			BufferedWriter bw = FileUtil.openOutputFile(new File("c:\\FormC.Sql"));

        for (int i = 0; i < sqlRows.length; i++) {
            dbw.insert(sqlRows[i]);
// The following is diagnostic for looking at the generated sql commands.
//				System.out.println(sqlRows[i]);
//				FileUtil.println(bw, sqlRows[i]);
//			}
//			FileUtil.close(bw);
//		}
//		catch (FileNotFoundException fnf) {
//			fnf.printStackTrace();
//		}
//		catch (IOException io) {
//			io.printStackTrace();
//		}
//		catch (Exception e) {
//			e.printStackTrace();
        }

        dbw.close();

    }
}
