package net.server.servlets;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

/**
 * FormC Class
 */

public class FormC extends HttpServlet {

    /**
     * If the user came througth the Login Prompt then the FormC selection
     * will be displayed for the respective user, otherwise process is
     * redirected to Login Page.
     *
     */

    static final String FORMC_PROPERTY_FILE = Globals.FORMC_PROPERTY_FILE;

    public void doGet(HttpServletRequest request,
                      HttpServletResponse response)
            throws IOException, ServletException {

        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        System.out.println("Loading FormC");

        HttpSession session = request.getSession(true);
        String user = (String) session.getValue("userId");

        if (user == null) {
            response.sendRedirect(getRedirectURL());
        } else {
            FormCData fcData = (FormCData) session.getValue("fcData");
            getFormC(request, response, session, out, fcData, user);
        }

    }

    /**
     * Calls the doGet() method
     *
     * @throws    java.io.IOException ServletException
     */

    public void doPost(HttpServletRequest request,
                       HttpServletResponse response)
            throws IOException, ServletException {

        doGet(request, response);
    }

    /**
     * getRedirectURL	 Method
     *
     * @return    		 String
     */

    private String getRedirectURL() {
        try {
            Properties prop = FileUtil.loadProperties("FormC.Property");
            System.out.println("The loginURL is " + prop.getProperty("LoginURL"));
            return prop.getProperty("LoginURL");
        } catch (PropFileException pfnf) {
            pfnf.printStackTrace();
            return null;
        }
    }

    /**
     * getFormC	 Method
     *

     */

    private void getFormC(HttpServletRequest request,
                          HttpServletResponse response,
                          HttpSession session,
                          PrintWriter out,
                          FormCData fcData,
                          String user) {

        String nextAction = (String) session.getValue("nextAction");

        System.out.println("Next action is " + nextAction);

        if (!nextAction.equals("FormC"))
            nextAction = request.getParameter("txtNextAction");

        if ((fcData == null) || (nextAction.equals("FormC"))) {
            session.putValue("nextAction", "CollectData");
            fcDataInit(session, out, fcData, user);
        } else if (nextAction.equals("CollectData")) {
            selectFormC(request, session, out, fcData);
        } else if (nextAction.equals("DisplayData")) {
            displayFormCData(request, session, out, fcData);
        } else if (nextAction.equals("SQL")) {
            out.println(fcData.getSqlFormC());
        }
    }

    /**
     * fcDataInit		 Method
     *
     */

    private void fcDataInit(HttpSession session, PrintWriter out,
                            FormCData fcData, String user) {
        if (fcData == null) {
            fcData = new FormCData();
            if (fcData.init()) {
                session.putValue("fcData", fcData);
//		        System.out.println("We are trying to initialize the data " + user);

                out.println(fcData.getDefaultFormC(user));
            } else {
                out.println(fcData.getErrorFormC());
            }
        } else {
            out.println(fcData.getDefaultFormC(user));
        }

    }


    /**
     * selectFormC		 Method
     *

     */

    private void selectFormC(HttpServletRequest request, HttpSession session,
                             PrintWriter out, FormCData fcData) {

        String term = request.getParameter("cboTerm");
        String course = request.getParameter("cboCourse");
        String section = request.getParameter("cboSection");

        out.println(fcData.getSelectFormC(term, course, section));

    }

    /**
     * displayFormCData	 Method
     *

     */

    private void displayFormCData(HttpServletRequest request,
                                  HttpSession session,
                                  PrintWriter out,
                                  FormCData fcData) {

        String[] iNames = RequestUtil.getParmNames(request);
        String[] iValues = RequestUtil.getParmValues(iNames, request);

        out.println(fcData.getDisplayFormC(iNames, iValues));

    }

}



