package net.rmi.rmiimage;

import java.rmi.Naming;

class StartBenchmark extends Thread {
  int servernumber;

  static BenchMark BM[] = new BenchMark[26];
  CpuPanel cpu[] = new CpuPanel[26];

  public static boolean checkServers(int i, String servername) {
    try {
      System.out.println("Looking up servers...");
      System.out.println("Checking server " + servername);
      BM[i] = (BenchMark) Naming.lookup(servername);
      System.out.println("Server checked!");
      return true;
    } catch (Exception e) {
      System.out.println("The exception in checking server: " + e);
    }
    return false;
  }

  public StartBenchmark(int i, CpuPanel Cpu) {
    servernumber = i;
    cpu[i] = Cpu;
  }

  public void run() {
    long starttime, endtime;
    try {
      starttime = System.currentTimeMillis();
      BM[servernumber].multiplyBench(999999);
      endtime = System.currentTimeMillis();
      System.out.println("The time taken is: " +
                         (endtime - starttime));
      cpu[servernumber].setSpeed((endtime - starttime));
    } catch (Exception e) {
      System.out.println(e);
    }
  }
}

public class Client {
  static String serverNames[] = {
    "rmi://" + "192.107.38.221" + ":1099/HelloServer",
    "rmi://" + "192.107.38.222" + ":1099/Helloserver",
    "rmi://" + "192.107.38.223" + ":1099/HelloServer",
    "rmi://" + "192.107.38.224" + ":1099/HelloServer",
    "rmi://" + "192.107.38.225" + ":1099/HelloServer",
    "rmi://" + "192.107.38.226" + ":1099/HelloServer",
    "rmi://" + "192.107.38.227" + ":1099/HelloServer",
    "rmi://" + "192.107.38.228" + ":1099/HelloServer",
    "rmi://" + "192.107.38.229" + ":1099/HelloServer",
    "rmi://" + "192.107.38.230" + ":1099/HelloServer",
    "rmi://" + "192.107.38.231" + ":1099/HelloServer",
    "rmi://" + "192.107.38.80" + ":1099/HelloServer",
    "rmi://" + "192.107.38.81" + ":1099/HelloServer",
    "rmi://" + "192.107.38.82" + ":1099/HelloServer",
    "rmi://" + "192.107.38.83" + ":1099/HelloServer",
    "rmi://" + "192.107.38.84" + ":1099/HelloServer",
    "rmi://" + "192.107.38.85" + ":1099/HelloServer",
    "rmi://" + "192.107.38.86" + ":1099/HelloServer",
    "rmi://" + "192.107.38.87" + ":1099/HelloServer",
    "rmi://" + "192.107.38.88" + ":1099/HelloServer",
    "rmi://" + "192.107.38.89" + ":1099/HelloServer",
    "rmi://" + "192.107.38.92" + ":1099/HelloServer",
    "rmi://" + "192.107.38.93" + ":1099/HelloServer",
    "rmi://" + "192.107.38.94" + ":1099/HelloServer",
    "rmi://" + "192.107.38.95" + ":1099/HelloServer",
    "rmi://" + "192.107.38.96" + ":1099/HelloServer",
    "rmi://" + "192.107.38.97" + ":1099/HelloServer",
    "rmi://" + "192.107.38.98" + ":1099/HelloServer"
  };

  StartBenchmark sb[] = new StartBenchmark[serverNames.length];
  boolean b[] = new boolean[serverNames.length];

  public Client(int statearr[]) {
    for (int i = 0; i < serverNames.length; i++) {
      if (statearr[i] == 1)
        b[i] = StartBenchmark.checkServers(i,
                                           serverNames[i]);
    }
  }

  public void Start(int i, CpuPanel Cpu) {
    if (b[i]) //&& !(sb[i].isAlive()))
    {
      sb[i] = new StartBenchmark(i, Cpu);
      sb[i].start();
    } else
      System.out.println("Server " + serverNames[i] + " not found");
  }
}
