package net.rmi.armi;

import net.rmi.utils.RmiRegistryUtils;
import net.rmi.utils.Compile;

import java.rmi.RemoteException;
import java.rmi.registry.Registry;

public class RmiHelloServer {
    // before you run this program,
    // you must start the rmiregistry
    // from the classpath root.
    public static void main(String args[]) {
        try {
            startServer();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static void startServer()
            throws RemoteException {
        println("starting server");
        Class c = RemoteHelloImplementation.class;
        Compile.runRmic(c);
        RemoteHelloInterface ro = new RemoteHelloImplementation();

        bindInstances(ro);
    }

    private static void bindInstances(RemoteHelloInterface ro) throws RemoteException {
        println("binding remote instances");
        // We don't need Naming anymore...
        //Naming.rebind("RemoteHello",ro);
        Registry r = RmiRegistryUtils.getRegistry();
        r.rebind("RemoteHello", ro);
        println("waiting for invocations");
    }

    public static void println(Object o) {
        System.out.println(o);
    }
}
