package net.rmi.armi;

import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class RmiHelloClient {
    private String rmiUrl = null;
    private RemoteHelloInterface remoteHelloInterface = null;

    public RmiHelloClient(String location) {
        rmiUrl = location;
        try {
            remoteHelloInterface = lookupRemoteHelloInterface();
        } catch (NotBoundException e) {
            e.printStackTrace();
        } catch (java.net.MalformedURLException e) {
            e.printStackTrace();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }
    public RemoteHelloInterface getRemoteHelloInterface() {
        return remoteHelloInterface;
    }

    private RemoteHelloInterface lookupRemoteHelloInterface()
            throws NotBoundException,
            java.net.MalformedURLException,
            RemoteException {
        RemoteHelloInterface rh = (RemoteHelloInterface)
                Naming.lookup(rmiUrl);
        return rh;
    }

    public static void main(String args[]) {
        try {
            RmiHelloClient rhc =
                    new RmiHelloClient(
                            "rmi://172.16.11.105/RemoteHello");
            RemoteHelloInterface rhi = rhc.getRemoteHelloInterface();
            String ans = rhi.getMsg();
            rhi.testGetMsg();
            System.out.println(ans);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }
    public String getMsg() throws RemoteException {
        return remoteHelloInterface.getMsg();
    }

    public void testGetMsg()
            throws
            RemoteException {
        System.out.println(remoteHelloInterface.getMsg());
    }
}
