package net.rmi.armi;

// net.rmi.armi.RemoteHelloImplementation;

import net.rmi.utils.Compile;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class RemoteHelloImplementation
        extends UnicastRemoteObject
        implements RemoteHelloInterface {
    HelloWorld hw = new HelloWorld();

    public static void main(String[] args) {
        boolean stubsGenerated = generateStubs();
        System.out.println("generated Stubs");
    }

    private static boolean generateStubs() {
        Compile.rmic(RemoteHelloImplementation.class);
        return true;
    }

    public RemoteHelloImplementation()
            throws RemoteException {
    }

    public void testGetMsg() throws RemoteException {
        hw.testGetMsg();
    }

    public String getMsg() throws RemoteException {
        return hw.getMsg();
    }
}

// use the rmic compiler to create a stub
// rmic -v1.2 -d . net.rmi.armi.RemoteHelloImplementation
