package net.multicast;

import java.net.MulticastSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.io.IOException;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 24, 2004
 * <p/>
 * Time: 6:30:54 PM
 */
public class Utils {
    public static MulticastSocket getMulticastSocket(int port,
                                                     InetAddress inetAddress)
            throws IOException {

        MulticastSocket mcastSocket = new MulticastSocket(port);
        mcastSocket.setReuseAddress(true);
        mcastSocket.setLoopbackMode(false);
        System.out.println("loopback="+mcastSocket.getLoopbackMode());
        mcastSocket.setTimeToLive(2);
        // This enables me to see stuff in the group....
        mcastSocket.joinGroup(inetAddress);

        return mcastSocket;
    }



    public static InetAddress getInetAddress()
            throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName("224.111.112.113");
        if (!inetAddress.isMulticastAddress()) {
            System.out.println("The address: " +
                    inetAddress +
                    " is not multicast address");
            System.exit(0);
        }
        return inetAddress;
    }

    public static void closeSocket(MulticastSocket mcastSocket,
                                   InetAddress inetAddress)
            throws IOException {
        mcastSocket.leaveGroup(inetAddress);
        mcastSocket.close();
    }
}
