package net.multicast;

import gui.JInfoFrame;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.InetAddress;

/**
 * Copyright DocJava, inc.
 * User: lyon
 * Date: Oct 27, 2004
 * Time: 5:08:08 AM
 */

class ChatThread extends Thread {

    private MulticastSocket msocket;
    private DatagramPacket recv;
    private JInfoFrame jif;

    public ChatThread(MulticastSocket msock,JInfoFrame jif) {
        this.jif = jif;
        msocket = msock;
        start();                // start calls run
    }

    public void run() {
        byte[] buf = new byte[100000];
        String tmp;
        try {
            while (true) {
                // Handle the incoming data and print it to stnd output.
                recv = new DatagramPacket(buf, buf.length);
                msocket.receive(recv);
                tmp = new String(recv.getData(), 0, recv.getLength());
                InetAddress address = recv.getAddress();
                jif.println(address.getCanonicalHostName());
                jif.println("\n\nRecived: \"" +
                        "ip="+address+
                        tmp +
                        "\"\nMessage Length is: " +
                        tmp.length());
            }

        } catch (IOException e) {
            jif.println("Exit...");
            e.printStackTrace();
        } finally {
            msocket.close();
        }
    }

}
