package net.multicast;

import futils.Futil;
import futils.ReaderUtil;
import gui.JInfoFrame;
import gui.run.RunTextField;

import java.awt.*;
import java.io.*;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;


/**
 * Copyright DocJava, inc. User: lyon Date: Oct 27, 2004 Time: 4:59:20 AM
 */
public class ChatMain {
    public static void main(String[] args) throws IOException {
        int port = 1234;
        InetAddress inetAddress = Utils.getInetAddress();
        try {
            MulticastSocket mcastSocket = Utils.getMulticastSocket(port,
                    inetAddress);

            processWithMulticastSocket(mcastSocket, inetAddress, port);

            //Utils.closeSocket(mcastSocket, inetAddress);
        } catch (Exception err) {
            err.printStackTrace();
        }
    }

    public static void processWithMulticastSocket(
            final MulticastSocket mcastSocket,
            final InetAddress inetAddress,
            final int port) {

        // ChatThread will handle the incoming
        // Data and print it out to STDN output.
        JInfoFrame jif = new JInfoFrame();
        new ChatThread(mcastSocket,jif);
        Container c = jif.getContentPane();
        RunTextField rtf = new RunTextField() {
            public void run() {
                try {
                    sendALine(getText(), inetAddress, port, mcastSocket);
                } catch (IOException e) {
                    e.printStackTrace();

                }
            }
        };
        c.add(rtf, BorderLayout.SOUTH);
        jif.setSize(400, 200);
        jif.show();



    }

    private static void sendALine(String strin,
                                  InetAddress inetAddress,
                                  int port, MulticastSocket mcastSocket)
            throws IOException {
        if (strin.startsWith("open:")) {
            sendAFile(inetAddress,
                    port,
                    mcastSocket);

        }

        DatagramPacket dp = new DatagramPacket(strin.getBytes(),
                strin.length(),
                inetAddress,
                port);
        mcastSocket.send(dp);
    }



    private static void sendAFile(InetAddress inetAddress,
                                  int port,
                                  MulticastSocket mcastSocket) {
        System.out.println("SendAFile_");
        File f = Futil.getReadFile("select a text file");
        sendAFile(f,
                inetAddress,
                port,
                mcastSocket);
    }

    private static void sendAFile(File f,
                                  InetAddress inetAddress,
                                  int port,
                                  MulticastSocket mcastSocket) {
        try {
            String sa[] = ReaderUtil.getFile(f);
            byte b[] = ReaderUtil.getBytes(sa);
            DatagramPacket dp = new DatagramPacket(b,
                    b.length,
                    inetAddress,
                    port);
            mcastSocket.send(dp);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}

