package net.date;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;

public class SimpleClock {
    private static BufferedReader getTimeBufferedReader()
            throws UnknownHostException,
            IOException {
        Socket s = new Socket(
                "time-A.timefreq.bldrdoc.gov", 13);
        return new BufferedReader(
                new InputStreamReader(
                        s.getInputStream()));
    }

    /**
     *  return a string representing the time from NIST
     *  output looks like:
     * 52520 02-09-03 11:06:08 50 0 0 537.5 UTC(NIST) *
     */
    public static String getTime() {
        String time = "";
        try {
            BufferedReader br = getTimeBufferedReader();
            String s = null;
            while ((s = br.readLine()) != null)
                time = time + s;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return time;
    }

    public static void main(String[] args) {
        System.out.println("Running simple clock:");
        System.out.println(SimpleClock.getTime());
        System.out.println("clock done");
    }
}
