package net.compute;

import classUtils.dumper.ClassFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * Created by
 * User: lyon
 * Date: Aug 19, 2003
 * Time: 9:22:07 AM
 *
 */

/**
 * Defines a Class Loader that knows how to read a class
 * from the local file system.
 */
public abstract class LocalClassLoader extends java.lang.ClassLoader {
    private String directory;

    public LocalClassLoader(String dir) {
        directory = dir;
    }

    private LocalClassLoader() {
    }

    public Class loadClassFromFile(String className, boolean resolve)
            throws ClassNotFoundException, FileNotFoundException {
        File target =
                new File(directory
                + className.replace('.', '/')
                + ".class");
        if (!target.exists()) throw new java.io.FileNotFoundException();
        try {
            return
                    loadClassFromFile(target,
                            className,
                            resolve);
        } catch (IOException e) {
            System.out.println("Aborting read: "
                    + e.toString()
                    + " in LocalClassLoader.");
            throw new ClassNotFoundException();
        }
    }

    public Class loadClassFromFile(File fileTarget,
                                   boolean resolve)
            throws IOException {
        long bytecount = fileTarget.length();
        byte[] buffer = new byte[(int) bytecount];
        FileInputStream f = new FileInputStream(fileTarget);
        int readCount = f.read(buffer);
        f.close();
        System.out.println("read in:" + buffer.length + " bytes");
        System.out.println("file name=:" + fileTarget.getName());
        // This is where it dies....
        ClassFile cf = ClassFile.getClassFile(fileTarget);
        Class c = defineClass(cf.getClassName(), buffer, 0, (int) bytecount);
        System.out.println("This is never reached");
        if (resolve) resolveClass(c);
        System.out.println("[Loaded " + c.getName()
                + " from " + fileTarget
                + " (" + bytecount + " bytes)]");
        return c;
    }

    public Class loadClassFromFile(File fileTarget, String className,
                                   boolean resolve)
            throws IOException {
        long bytecount = fileTarget.length();
        byte[] buffer = new byte[(int) bytecount];
        FileInputStream f = new FileInputStream(fileTarget);
        int readCount = f.read(buffer);
        f.close();
        Class c = defineClass(className, buffer, 0, (int) bytecount);
        if (resolve) resolveClass(c);
        System.out.println("[Loaded " + className
                + " from " + fileTarget
                + " (" + bytecount + " bytes)]");
        return c;
    }

    public static void doIt(String argv[]) {
        try {
            if (argv.length < 1) {
                System.out.println("Usage: java Test ");
                return;
            }
            String target = argv[0];
            DelegatingLoader loader =
                    new DelegatingLoader("ersatz/");
            Class c = loader.loadClass(target, true);
            Object[] arg = {};
            Class[] argClass = {};
            // invoke the main method on the given class
            // with the argument list.
            c.getMethod("main", argClass).invoke(null, arg);
        } catch (Exception e) {
            System.out.println("Error " + e.toString()
                    + " in Test.doIt.");
        }
    }
}

