package net.compute;

import java.io.File;
import java.io.IOException;

/**
 * Created by
 * User: lyon
 * Date: Aug 19, 2003
 * Time: 9:42:36 AM
 *
 */

/** A classloader that delegates some loads to the system loader,
 * and serves other requests by reading in from a given directory.
 */
public class DelegatingLoader extends LocalClassLoader {
    public DelegatingLoader(String dir) {
        super(dir);
    }
    public static Class getClassFromFile(File f){
        DelegatingLoader dl = new DelegatingLoader("");
        try {
           return dl.loadClassFromFile(f,true);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized Class loadClass(String name, boolean resolve)
            throws ClassNotFoundException {
        Class c;
        try {
            if (name.equals("RR") || name.startsWith("java.")||
                    name.startsWith("javax.") ||(findSystemClass(name) != null)){
                System.out.println("[Loaded " + name + " from system]");
                return this.findSystemClass(name);
            } else
                return this.loadClassFromFile(name, resolve);
        } catch (Exception d) {
            System.out.println("Exception " + d.toString() + " while loading " + name + " in DelegatingLoader.");
            throw new ClassNotFoundException();
        }
    }
}

