package net;


import com.jcraft.jsch.*;
import futils.Futil;
import gui.In;

import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import java.io.*;

public class ScpTo {
    public static void main(String[] arg) {
        scpTo();
    }

    public static void scpTo() {
        String user = In.getString("user id");
        String host = In.getString("host");

        File lfile = Futil.getReadFile(
                "local file");
        String rfile = "/var/www/html/book/cgij/code/jnlp/"+lfile.getName();
        UserInfo ui = new MyUserInfo();
        scpTo(lfile.toString(),
              user,
              host,
              rfile,
              ui);
    }

    public static void scpTo(String lfile,
                             String user,
                             String host,
                             String rfile,
                             UserInfo ui) {
        try {

            JSch jsch = new JSch();
            Session session = jsch.getSession(
                    user, host, 22);

            session.setUserInfo(ui);
            session.connect();


            // exec 'scp -t rfile' remotely
            String command = "scp -t " + rfile;
            Channel channel = session.openChannel(
                    "exec");
            ((ChannelExec) channel).setCommand(
                    command);

            // get I/O streams for remote scp
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();

            channel.connect();

            if (checkAck(in) != 0) {
                System.exit(0);
            }

            // send "C0644 filesize filename", where filename should not include '/'
            int filesize = (int) (new File(lfile)).length();
            command = "C0644 " + filesize + " ";
            if (lfile.lastIndexOf('/') > 0) {
                command +=
                lfile.substring(lfile.lastIndexOf(
                        '/') +
                                1);
            } else {
                command += lfile;
            }
            command += "\n";
            out.write(command.getBytes());
            out.flush();

            if (checkAck(in) != 0) {
                return;
            }

            // send a content of lfile
            FileInputStream fis = new FileInputStream(
                    lfile);
            byte[] buf = new byte[1024];
            while (true) {
                int len = fis.read(buf,
                                   0,
                                   buf.length);
                if (len <= 0) break;
                out.write(buf, 0, len);
                out.flush();
            }

            // send '\0'
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();

            if (checkAck(in) != 0) {
                System.exit(0);
            }

            return;
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    static int checkAck(InputStream in)
            throws IOException {
        int b = in.read();
        // b may be 0 for success,
        //          1 for error,
        //          2 for fatal error,
        //          -1
        if (b == 0) return b;
        if (b == -1) return b;

        if (b == 1 || b == 2) {
            StringBuffer sb = new StringBuffer();
            int c;
            do {
                c = in.read();
                sb.append((char) c);
            } while (c != '\n');
            if (b == 1) { // error
                System.out.print(sb.toString());
            }
            if (b == 2) { // fatal error
                System.out.print(sb.toString());
            }
        }
        return b;
    }

    public static class MyUserInfo
            implements UserInfo {


        public String getPassword() {
            return passwd;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        String passwd;
        JTextField passwordField = (JTextField) new JPasswordField(
                20);

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(
                String message) {
            return true;
        }

        public boolean promptPassword(
                String message) {
            Object[] ob = {passwordField};
            int result =
                    JOptionPane.showConfirmDialog(
                            null,
                            ob,
                            message,
                            JOptionPane.OK_CANCEL_OPTION);
            if (result == JOptionPane.OK_OPTION) {
                passwd = passwordField.getText();
                return true;
            } else {
                return false;
            }
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null,
                                          message);
        }
    }

}
