/*
 * Created by IntelliJ IDEA.
 * User: lyon
 * Date: Feb 15, 2003
 * Time: 1:22:04 PM
 */
package math;

import futils.WriterUtil;

import java.awt.*;

public class MathUtils {
    public static int getRandom() {
        return (int) ((Math.random() * 100) + 1);
    }

    public static void main(String args[]) {
        writeOutRandomNumbersToAFile();
    }

    public static void writeOutRandomNumbersToAFile() {
        int ia[] = new int[100];
        for (int i = 0; i < ia.length; i++)
            ia[i] = rand(1, 100);
        WriterUtil.writeString(
                WriterUtil.getCSVString(ia));
    }

    public static void randTest() {
        for (int i = 0; i < 100; i++) {
            System.out.print(rand(1, 10) + " ");
            if (i % 20 == 0) System.out.println();
        }
    }

    /**
     * Compute a random integer
     * @param min  minimum int
     * @param max  maximum int
     * @return random int between <code>min</code> and
     * <code>max</code> inclusive.
     */
    public static int rand(int min, int max) {
        return (int) (Math.round(
                Math.random() * (max - min) + min));
    }
    public static Color getRandomColor() {
        return new Color(rand(0,255),rand(0,255),rand(0,255));
    }

    public static boolean odd(int i) {
        if ((i & 1) == 1) return true;
        return false;
    }

    /**
     *
     * @param d input argument to the log2 function
     * @return  base 2 log.
     */
    public static int getLogBase2(double d) {
        return (int) (Math.log(d) / Math.log(2));
    }

    public static final double getGauss(
            double x,
            double xc, double sigma) {
        double oneOnSigmaSquaredOn2 = 1 / (sigma * sigma) / 2;
        return
                Math.exp(-((x - xc) * (x - xc)) *
                oneOnSigmaSquaredOn2) / Math.PI * oneOnSigmaSquaredOn2;
    }

    public static final double[] getGauss(int n) {
        double g[] = new double[n];
        for (int x = 0; x < n; x++)
            g[x] = getGauss(x, n / 2, 2);
        return g;
    }

    public static final void testGauss() {
        print(getGauss(10));
    }

    public static final void print(double d[]) {
        for (int i = 0; i < d.length; i++)
            System.out.println(d[i]);
    }
}
