/*
 * Copyright (C) 1997 Luke Gorrie
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge,
 * MA 02139, USA.
 */

package javagroup.util;

import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * Window-specific implementation of Resource.
 *
 * @author Luke Gorrie
 */
public class WindowResource extends Resource {

    protected Window _window;

    public WindowResource(Window window) {
        _window = window;
    }

    public Window getWindow() {
        return _window;
    }

    public void dispose() {
        if (_window == null)
            return;

        try {
            _window.dispose();
            _window = null;
        } catch (Exception e) {
            // ignore exceptions
        }
        super.dispose();
    }

    public String toString() {
        return "WindowResource: " + _window.toString();
    }

    final class WindowDisposalListener extends WindowAdapter {

        protected WindowResource _resource;

        public WindowDisposalListener(WindowResource window) {
            _resource = window;

            _resource.getWindow().addWindowListener(this);
        }

        public void windowClosed(WindowEvent event) {
            _resource.dispose();
        }

    }

}

