package javagroup.tools.processmanager;

import javagroup.process.ProcessManagerHolder;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ProcessWatcherPanel extends JPanel implements ActionListener {

    /**
     * Table containing process info *
     */
    protected JTable _processTable;
    protected JButton _killButton;
    protected ProcessDataModel _dataModel;

    private static final int __MINIMUM_HEIGHT = 200;
    public static final int CLICK_DURATION = 1000;

    public ProcessWatcherPanel() {

        ProcessDataModel myDataModel = new ProcessDataModel();
        _dataModel = myDataModel;
        JTable table = new JTable(myDataModel);
        _processTable = table;

        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(false);
        table.setCellSelectionEnabled(false);
        table.setSelectionMode(0); // SINGLE_SELECTION
        JCheckBox cb = new JCheckBox();
        TableColumn tCol = table.getColumn(
                table.getModel().getColumnName(ProcessDataModel.C_PID));

        tCol.setCellRenderer(new DefaultTableCellRenderer());
        tCol.setCellEditor(new DefaultCellEditor(cb));

        //Create the scroll pane and add the table to it.
        JScrollPane scrollPane = new JScrollPane(table);

        //Make the table heads be the non-scrolling column header.
        //JViewport columnHeading = new JViewport();
        //columnHeading.setView(table.getTableHeader());
        //columnHeading.setLayout(new BoxLayout(columnHeading,    //HACK
        //			  BoxLayout.X_AXIS));
        //scrollPane.setColumnHeader(columnHeading);

        _killButton = new JButton("Kill process");
        _killButton.addActionListener(this);

        this.setLayout(new BorderLayout());
        this.add("Center", scrollPane);
        this.add("South", _killButton);
    }

    public Dimension getPreferredSize() {
        Dimension pref_size = super.getPreferredSize();
        return
                new Dimension(pref_size.width,
                        Math.max(__MINIMUM_HEIGHT, pref_size.height));
    }

    protected void killCurrentSelection() {
        if (_processTable.getSelectedRow() >= _processTable.getRowCount())
            return;

        try {
            long pid;
            pid =
                    Long.parseLong((String) _dataModel
                    .getValueAt(_processTable.getSelectedRow(),
                            ProcessDataModel.C_PID));
            ProcessManagerHolder.getProcessManager().kill(pid);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent event) {

        killCurrentSelection();

    }

}

