package javagroup.tools.processmanager;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.WindowEvent;

public class ProcessManagerFrame extends JFrame
        implements java.awt.event.WindowListener {

    JTabbedPane _container = new JTabbedPane();

    public ProcessManagerFrame() {
        super("Process Manager");
        this.getContentPane().setLayout(new BorderLayout());

        ProcessWatcherPanel watcher = new ProcessWatcherPanel();
        LaunchProcessPanel launcher = new LaunchProcessPanel();

        JPanel pane = new JPanel();

        pane.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(),
                "Process Watcher"));

        //pane.setBorder(new JGroovedBorder());
        pane.setLayout(new BorderLayout());
        pane.add("Center", watcher);

        //watcher_pane.setBorder(new JGroovedBorder);
        //watcher_pane.add("Center", new ProcessWatcherPanel());
        this.getContentPane().add("Center", pane);

        pane = new JPanel();

        pane.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(),
                "Process Launcher"));

        //JBorderedPane launcher_pane = new JBorderedPane();
        //launcher_pane.setBorder(new JGroovedBorder);
        //launcher_pane.add(new LaunchProcessPanel());

        pane.setLayout(new BorderLayout());
        pane.add("Center", launcher);

        this.getContentPane().add("South", pane);
        addWindowListener(this);

        setSize(300, 250);
        validate();
        show();
    }


    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        setVisible(true);
        dispose();

        try {
            System.exit(0);
        } catch (SecurityException ignored) {
            // can't
        }
        // Luke: Disabled below - I personally don't want the processes to die when the
        // manager does.  I think of the process manager GUI as a client, rather than the
        // server, so the server lives on when it dies.  Uncomment the below if you'd
        // rather it the other way
        /*
          System.out.print("Shutting down. Please wait till all processes are killed ..");
          // All processes are killed before exiting. If it is not done,
          // JVM stays in memory (at least on Win95)

          ProcessManager pm=ProcessManagerHolder.getProcessManager();
          Enumeration processes = pm.getProcesses();

          // cycle and kill all
          while (processes.hasMoreElements())
          ((JProcess)processes.nextElement()).kill();

          // upon kill, all thread groups will be stopped.
          while (pm.getProcesses().hasMoreElements())
          {

          System.out.print(".");
          try
          {
          Thread.sleep(ProcessGarbageCollector.DEFAULT_INTERVAL);
          }
          catch(java.lang.InterruptedException ex)
          {}
          }
          System.out.println("");
          System.exit(0);
        */
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

}

